/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.dataset;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.dataset.DataSetDTO;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetType;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class DatasetFacade
extends AbstractFacade<Dataset> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public DatasetFacade() {
        super(Dataset.class);
    }

    public Dataset find(Integer id) {
        return (Dataset)this.em.find(Dataset.class, (Object)id);
    }

    public Optional<Dataset> findByPublicDsIdProject(String publicDsId, Project project) {
        TypedQuery query = this.em.createNamedQuery("Dataset.findByPublicDsIdProject", Dataset.class).setParameter("publicDsId", (Object)publicDsId).setParameter("project", (Object)project);
        try {
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<Dataset> findByPublicDsId(String publicDsId) {
        TypedQuery query = this.em.createNamedQuery("Dataset.findByPublicDsId", Dataset.class).setParameter("publicDsId", (Object)publicDsId);
        try {
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Dataset findByProjectAndName(Project project, String name) {
        if (project == null || name == null) {
            throw new IllegalArgumentException("Project and/or dataset name were not provided.");
        }
        try {
            return (Dataset)this.em.createNamedQuery("Dataset.findByProjectAndName", Dataset.class).setParameter("project", (Object)project).setParameter("name", (Object)name).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<Dataset> findByProject(Project project) {
        TypedQuery query = this.em.createNamedQuery("Dataset.findByProject", Dataset.class).setParameter("project", (Object)project);
        return query.getResultList();
    }

    public List<DataSetDTO> findPublicDatasets() {
        TypedQuery query = this.em.createNamedQuery("Dataset.findAllPublic", Dataset.class);
        List datasets = query.getResultList();
        ArrayList<DataSetDTO> ds = new ArrayList<DataSetDTO>();
        for (Dataset d : datasets) {
            DataSetDTO dto = new DataSetDTO();
            dto.setDescription(d.getDescription());
            dto.setName(d.getName());
            ds.add(dto);
        }
        return ds;
    }

    public List<Dataset> findAllPublicDatasets() {
        TypedQuery query = this.em.createNamedQuery("Dataset.findAllPublic", Dataset.class);
        return query.getResultList();
    }

    public List<Dataset> findPublicDatasetsByState(int publicDs) {
        TypedQuery query = this.em.createNamedQuery("Dataset.findPublicByState", Dataset.class).setParameter("publicDs", (Object)publicDs);
        return query.getResultList();
    }

    public void persistDataset(Dataset dataset) {
        this.em.persist((Object)dataset);
    }

    public void flushEm() {
        this.em.flush();
    }

    public void merge(Dataset dataset) {
        this.em.merge((Object)dataset);
        this.em.flush();
    }

    public void removeDataset(Dataset dataset) {
        Dataset ds = (Dataset)this.em.find(Dataset.class, (Object)dataset.getId());
        if (ds != null) {
            this.em.remove((Object)ds);
        }
    }

    public AbstractFacade.CollectionInfo findAllDatasetByProject(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort, Project project) {
        String queryStr = this.buildQuery("SELECT d FROM Dataset d ", filter, sort, "d.project = :project ");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT d.id) FROM Dataset d ", filter, null, "d.project = :project ");
        TypedQuery query = this.em.createQuery(queryStr, Dataset.class).setParameter("project", (Object)project);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, Dataset.class).setParameter("project", (Object)project);
        this.setFilter(filter, (Query)query);
        this.setFilter(filter, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case NAME: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam());
                break;
            }
            case ACCEPTED: 
            case PUBLIC: 
            case SHARED: 
            case SEARCHABLE: {
                q.setParameter(filterBy.getField(), (Object)this.getBooleanValue(filterBy.getParam()));
                break;
            }
            case TYPE: {
                q.setParameter(filterBy.getField(), (Object)this.getEnumValue(filterBy.getField(), filterBy.getValue(), DatasetType.class));
                break;
            }
        }
    }

    public static enum Filters {
        NAME("NAME", "d.name LIKE CONCAT(:name, '%') ", "name", " "),
        ACCEPTED("ACCEPTED", "true =:accepted ", "accepted", "true"),
        SHARED("SHARED", "NOT :shared ", "shared", "true"),
        SEARCHABLE("SEARCHABLE", "d.searchable =:searchable ", "searchable", "0"),
        TYPE("TYPE", "d.dsType =:dsType ", "dsType", "DATASET"),
        PUBLIC("PUBLIC", "d.public =:public ", "public", "0");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", "d.id ", "ASC"),
        NAME("NAME", "LOWER(d.name) ", "ASC"),
        SEARCHABLE("SEARCHABLE", "d.searchable ", "ASC"),
        PUBLIC("PUBLIC", "d.public ", "ASC"),
        TYPE("TYPE", "d.dsType ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

