/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.search;

import io.hops.hopsworks.common.opensearch.OpenSearchClientController;
import io.hops.hopsworks.common.util.PayaraClusterManager;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.OpenSearchException;
import java.io.Serializable;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.GetAliasesResponse;
import org.opensearch.client.indices.CreateIndexRequest;
import org.opensearch.client.indices.GetIndexTemplatesResponse;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.common.xcontent.XContentFactory;

@Singleton
@Startup
@DependsOn(value={"Settings"})
@Lock(value=LockType.READ)
public class PyPiLibraryOpenSearchIndexer {
    @EJB
    private OpenSearchClientController openSearchClientCtrl;
    @EJB
    private Settings settings;
    @EJB
    private PayaraClusterManager payaraClusterManager;
    @Resource
    private TimerService timerService;
    private Timer timer;
    private boolean isIndexed = false;
    private static final Logger LOGGER = Logger.getLogger(PyPiLibraryOpenSearchIndexer.class.getName());

    @Lock(value=LockType.WRITE)
    public void updateIndexed() {
        if (this.settings.isPyPiIndexerTimerEnabled()) {
            try {
                GetAliasesResponse pypiAlias = this.openSearchClientCtrl.getAliases("pypi_libraries");
                this.isIndexed = !pypiAlias.getAliases().isEmpty();
            }
            catch (OpenSearchException e) {
                LOGGER.log(Level.SEVERE, "Exception occurred trying to get indices.", e);
            }
        }
    }

    public boolean isIndexed() {
        if (!this.isIndexed) {
            this.updateIndexed();
        }
        return this.isIndexed;
    }

    @PostConstruct
    public void init() {
        if (this.settings.isPyPiIndexerTimerEnabled()) {
            this.timer = this.timerService.createTimer(0L, 600000L, (Serializable)((Object)"PyPi Search Indexer"));
        } else {
            LOGGER.log(Level.INFO, "PyPi Indexer is disabled, will not index libraries in opensearch");
        }
    }

    private String getTimeStampFromIndex(String index) {
        return index.replace("pypi_libraries_", "");
    }

    private long getRecentIndex(Set<String> keySet) {
        if (keySet.size() > 1) {
            LOGGER.log(Level.WARNING, "Found more than one index for Alias: {0}", "pypi_libraries");
        }
        OptionalLong index = keySet.stream().map(this::getTimeStampFromIndex).mapToLong(Long::parseLong).max();
        return index.orElse(0L);
    }

    private long getIndexAge() {
        try {
            GetAliasesResponse pypiAlias = this.openSearchClientCtrl.getAliases("pypi_libraries");
            if (pypiAlias != null && pypiAlias.getAliases() != null && !pypiAlias.getAliases().isEmpty()) {
                long lastIndexed = this.getRecentIndex(pypiAlias.getAliases().keySet());
                long interval = System.currentTimeMillis() - lastIndexed;
                LOGGER.log(Level.FINE, "PyPi Alias last indexed: {0} HOURS ago", TimeUnit.MILLISECONDS.toHours(interval));
                return interval;
            }
        }
        catch (OpenSearchException e) {
            LOGGER.log(Level.WARNING, "Failed to get PyPi Alias: {0}", e.getMessage());
        }
        return Long.MAX_VALUE;
    }

    private boolean shouldIndex() {
        if (this.payaraClusterManager.amIThePrimary()) {
            String rawInterval = this.settings.getPyPiIndexerTimerInterval();
            Long intervalValue = this.settings.getConfTimeValue(rawInterval);
            TimeUnit intervalTimeunit = this.settings.getConfTimeTimeUnit(rawInterval);
            long interval = intervalTimeunit.toMillis(intervalValue);
            long lastIndexed = this.getIndexAge();
            return lastIndexed > interval;
        }
        return false;
    }

    @Timeout
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void execute(Timer timer) throws OpenSearchException {
        block12: {
            if (!this.shouldIndex()) {
                return;
            }
            LOGGER.log(Level.INFO, "Running PyPi Indexer");
            try {
                ClusterHealthResponse clusterHealthResponse = this.openSearchClientCtrl.clusterHealthGet();
                GetIndexTemplatesResponse templateResponse = this.openSearchClientCtrl.templateGet("pypi_libraries");
                if (clusterHealthResponse.getStatus().equals((Object)ClusterHealthStatus.RED)) {
                    LOGGER.log(Level.INFO, "OpenSearch currently down, rescheduling indexing for pypi libraries");
                    return;
                }
                if (templateResponse.getIndexTemplates().isEmpty()) {
                    LOGGER.log(Level.INFO, "OpenSearch template pypi_libraries currently missing, rescheduling indexing for pypi libraries");
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception occurred trying to index pypi libraries, rescheduling timer", e);
                return;
            }
            String newIndex = "pypi_libraries_" + System.currentTimeMillis();
            try {
                GetAliasesResponse pypiAlias = this.openSearchClientCtrl.getAliases("pypi_libraries");
                String[] indicesToDelete = this.openSearchClientCtrl.mngIndicesGetBySimplifiedRegex("pypi_libraries_*");
                Element body = Jsoup.connect((String)this.settings.getPyPiSimpleEndpoint()).maxBodySize(0).get().body();
                Elements elements = body.getElementsByTag("a");
                CreateIndexRequest createIndexRequest = new CreateIndexRequest(newIndex);
                this.openSearchClientCtrl.mngIndexCreate(createIndexRequest);
                int bulkSize = 100;
                int currentBulkSize = 0;
                int currentId = 0;
                BulkRequest bulkRequest = new BulkRequest();
                LOGGER.log(Level.INFO, "Starting to index libraries from pypi simple index");
                for (Element library : elements) {
                    IndexRequest indexRequest = ((IndexRequest)new IndexRequest().index(newIndex)).id(String.valueOf(currentId)).source(XContentFactory.jsonBuilder().startObject().field("library", library.text()).endObject());
                    bulkRequest.add(indexRequest);
                    ++currentId;
                    if (++currentBulkSize != 100) continue;
                    this.openSearchClientCtrl.bulkUpdateDoc(bulkRequest);
                    bulkRequest = new BulkRequest();
                    currentBulkSize = 0;
                }
                if (bulkRequest.numberOfActions() > 0) {
                    this.openSearchClientCtrl.bulkUpdateDoc(bulkRequest);
                }
                if (pypiAlias.getAliases().isEmpty()) {
                    this.openSearchClientCtrl.createAlias("pypi_libraries", newIndex);
                } else {
                    String currentSearchIndex = (String)pypiAlias.getAliases().keySet().iterator().next();
                    this.openSearchClientCtrl.aliasSwitchIndex("pypi_libraries", currentSearchIndex, newIndex);
                }
                LOGGER.log(Level.INFO, "Finished indexing");
                for (String index : indicesToDelete) {
                    DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest().indices(new String[]{index});
                    this.openSearchClientCtrl.mngIndexDelete(deleteIndexRequest);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Indexing pypi libraries failed", ex);
                if (!this.openSearchClientCtrl.mngIndexExists(newIndex)) break block12;
                DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest().indices(new String[]{newIndex});
                this.openSearchClientCtrl.mngIndexDelete(deleteIndexRequest);
            }
        }
    }
}

