/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.dataset;

import io.hops.hopsworks.common.dao.user.UserCardDTO;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetPermissions;
import io.hops.hopsworks.persistence.entity.dataset.DatasetType;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeam;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class DataSetDTO {
    private Long inodeId;
    private String name;
    private String description;
    private boolean isPublic;
    private boolean searchable;
    private boolean generateReadme;
    private DatasetPermissions permissions;
    private int template;
    private Integer projectId;
    private List<Integer> projectIds;
    private String projectName;
    private String templateName;
    private List<UserCardDTO> projectTeam;
    private List<String> sharedWith;
    private DatasetType type;

    public DataSetDTO() {
    }

    public DataSetDTO(String name, String description, boolean searchable, int template, boolean generateReadme) {
        this.name = name;
        this.description = description;
        this.searchable = searchable;
        this.template = template;
        this.generateReadme = generateReadme;
    }

    public DataSetDTO(Dataset ds, Inode datasetInode, Project project, List<String> sharedWith) {
        this.inodeId = datasetInode.getId();
        this.name = datasetInode.getInodePK().getName();
        this.description = ds.getDescription();
        this.projectName = project.getName();
        this.sharedWith = sharedWith;
        this.projectTeam = new ArrayList<UserCardDTO>();
        this.isPublic = ds.isPublicDs();
        this.searchable = ds.isSearchable();
        for (ProjectTeam member : project.getProjectTeamCollection()) {
            this.projectTeam.add(new UserCardDTO(member.getUser().getFname(), member.getUser().getLname(), member.getUser().getEmail()));
        }
        this.type = ds.getDsType();
    }

    public DataSetDTO(String name, Long inodeId, Project project) {
        this.inodeId = inodeId;
        this.name = name;
        this.projectName = project.getName();
        this.projectTeam = new ArrayList<UserCardDTO>();
        for (ProjectTeam member : project.getProjectTeamCollection()) {
            this.projectTeam.add(new UserCardDTO(member.getUser().getFname(), member.getUser().getLname(), member.getUser().getEmail()));
        }
    }

    public Long getInodeId() {
        return this.inodeId;
    }

    public void setInodeId(Long inodeId) {
        this.inodeId = inodeId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    public int getTemplate() {
        return this.template;
    }

    public void setTemplate(int template) {
        this.template = template;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public List<Integer> getProjectIds() {
        return this.projectIds;
    }

    public void setProjectIds(List<Integer> projectIds) {
        this.projectIds = projectIds;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public List<UserCardDTO> getMembers() {
        return this.projectTeam;
    }

    public void setMembers(List<UserCardDTO> members) {
        this.projectTeam = members;
    }

    public List<String> getSharedWith() {
        return this.sharedWith;
    }

    public void setSharedWith(List<String> sharedWith) {
        this.sharedWith = sharedWith;
    }

    public DatasetPermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(DatasetPermissions permissions) {
        this.permissions = permissions;
    }

    public List<UserCardDTO> getProjectTeam() {
        return this.projectTeam;
    }

    public void setProjectTeam(List<UserCardDTO> projectTeam) {
        this.projectTeam = projectTeam;
    }

    public boolean isIsPublic() {
        return this.isPublic;
    }

    public void setIsPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public boolean isGenerateReadme() {
        return this.generateReadme;
    }

    public void setGenerateReadme(boolean generateReadme) {
        this.generateReadme = generateReadme;
    }

    public void setType(DatasetType type) {
        this.type = type;
    }

    public DatasetType getType() {
        return this.type;
    }

    public String toString() {
        return "DataSetDTO{name=" + this.name + ", description=" + this.description + ", searchable=" + this.searchable + ", generateReadme=" + this.generateReadme + ", template=" + this.template + '}';
    }
}

