/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dataset.acl;

import io.hops.hopsworks.common.dataset.acl.PermissionsFixer;
import io.hops.hopsworks.common.util.PayaraClusterManager;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;

@Startup
@Singleton
public class PermissionsCleaner {
    private static final Logger LOGGER = Logger.getLogger(PermissionsCleaner.class.getName());
    @EJB
    private PermissionsFixer permissionsFixer;
    @EJB
    private PayaraClusterManager payaraClusterManager;
    @Resource
    private TimerService timerService;
    private Timer timer;
    private int counter = 0;

    @PostConstruct
    public void init() {
        long intervalDuration = 900000L;
        this.timer = this.timerService.createIntervalTimer(0L, intervalDuration, new TimerConfig((Serializable)((Object)"Fix dataset permissions timer"), false));
    }

    @PreDestroy
    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Timeout
    public void fixDatasetPermissions(Timer timer) {
        if (!this.payaraClusterManager.amIThePrimary()) {
            return;
        }
        this.counter = this.permissionsFixer.fixPermissions(this.counter, System.currentTimeMillis());
        if (this.counter > 0) {
            LOGGER.log(Level.INFO, "Fix permissions triggered by timer counter={0}", this.counter);
        }
    }
}

