/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.datavalidationv2.results;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.Expectation;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.IngestionResult;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.ValidationResult;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.validation.ConstraintViolationException;

@Stateless
public class ValidationResultFacade
extends AbstractFacade<ValidationResult> {
    private static final Logger LOGGER = Logger.getLogger(ValidationResultFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public ValidationResultFacade() {
        super(ValidationResult.class);
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void persist(ValidationResult validationResult) {
        try {
            this.em.persist((Object)validationResult);
            this.em.flush();
        }
        catch (ConstraintViolationException cve) {
            LOGGER.log(Level.WARNING, "Could not persist the new ValidationResult", cve);
        }
    }

    public Optional<ValidationResult> findById(Integer id) {
        try {
            return Optional.of(this.em.createNamedQuery("ValidationResult.findById", ValidationResult.class).setParameter("id", (Object)id).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public AbstractFacade.CollectionInfo<ValidationResult> findByExpectation(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, Expectation expectation) {
        String queryStr = this.buildQuery("SELECT vr from ValidationResult vr ", filters, sorts, "vr.expectation = :expectation");
        String queryCountStr = this.buildQuery("SELECT COUNT(vr.id) from ValidationResult vr ", filters, sorts, "vr.expectation = :expectation");
        TypedQuery query = this.em.createQuery(queryStr, ValidationResult.class).setParameter("expectation", (Object)expectation);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, ValidationResult.class).setParameter("expectation", (Object)expectation);
        this.setFilter(filters, (Query)query);
        this.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        ArrayList<IngestionResult> ingestionResultFilterValues = new ArrayList<IngestionResult>();
        for (AbstractFacade.FilterBy filterBy : filter) {
            if ("INGESTION_RESULT_EQ".equals(filterBy.getValue())) {
                switch (filterBy.getParam().toUpperCase()) {
                    case "INGESTED": {
                        ingestionResultFilterValues.add(IngestionResult.INGESTED);
                        break;
                    }
                    case "REJECTED": {
                        ingestionResultFilterValues.add(IngestionResult.REJECTED);
                        break;
                    }
                    case "FG_DATA": {
                        ingestionResultFilterValues.add(IngestionResult.FG_DATA);
                        break;
                    }
                    case "EXPERIMENT": {
                        ingestionResultFilterValues.add(IngestionResult.EXPERIMENT);
                        break;
                    }
                    case "UNKNOWN": {
                        ingestionResultFilterValues.add(IngestionResult.UNKNOWN);
                        break;
                    }
                }
            }
            if (!filterBy.getValue().contains("VALIDATION_TIME")) continue;
            q.setParameter(filterBy.getField(), (Object)new Timestamp(Long.parseLong(filterBy.getParam())));
        }
        if (ingestionResultFilterValues.size() > 0) {
            q.setParameter("ingestionResult", ingestionResultFilterValues);
        }
    }

    public static enum Filters {
        VALIDATION_TIME_GT("VALIDATION_TIME_GT", "vr.validationTime > :validationTime ", "validationTime", ""),
        VALIDATION_TIME_LT("VALIDATION_TIME_LT", "vr.validationTime < :validationTime ", "validationTime", ""),
        VALIDATION_TIME_GTE("VALIDATION_TIME_GTE", "vr.validationTime >= :validationTime ", "validationTime", ""),
        VALIDATION_TIME_LTE("VALIDATION_TIME_LTE", "vr.validationTime <= :validationTime ", "validationTime", ""),
        VALIDATION_TIME_EQ("VALIDATION_TIME_EQ", "vr.validationTime = :validationTime ", "validationTime", ""),
        INGESTION_RESULT_EQ("INGESTION_RESULT_EQ", "vr.ingestionResult IN :ingestionResult ", "ingestionResult", "");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        VALIDATION_TIME("VALIDATION_TIME", "vr.validationTime ", "DESC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }
}

