/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.flink;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.jobs.flink.FlinkController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.security.UserNotFoundException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.flink.configuration.GlobalConfiguration;

@Singleton
@Startup
@DependsOn(value={"Settings"})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class FlinkCompletedJobsCache {
    private static final Logger LOGGER = Logger.getLogger(FlinkCompletedJobsCache.class.getName());
    private LoadingCache<String, Project> cache;
    @EJB
    private FlinkController flinkController;
    @EJB
    private ProjectTeamFacade projectTeamFacade;
    @EJB
    private Settings settings;

    @PostConstruct
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void init() {
        try {
            final String archivePath = this.getArchiveDir(this.settings.getFlinkConfDir());
            this.cache = CacheBuilder.newBuilder().maximumSize(1000000L).build((CacheLoader)new CacheLoader<String, Project>(){

                public Project load(String job) throws UserNotFoundException {
                    LOGGER.log(Level.FINE, "Fetching Flink job project for job:" + job);
                    return FlinkCompletedJobsCache.this.flinkController.getProjectOfFlinkJob(archivePath, job);
                }
            });
            Map<String, Project> jobsProjects = this.flinkController.getProjectsOfFlinkJobs(archivePath);
            for (String job : jobsProjects.keySet()) {
                LOGGER.log(Level.FINER, "Filling cache with job:" + job + ", project:" + jobsProjects.get(job));
                this.cache.put((Object)job, (Object)jobsProjects.get(job));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not access configuration file", e);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public boolean hasAccessToFlinkJob(String job, Users user) {
        try {
            return this.projectTeamFacade.isUserMemberOfProject((Project)this.cache.getUnchecked((Object)job), user);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, e.getMessage(), e);
            return false;
        }
    }

    public String getArchiveDir(String flinkConfDir) {
        return GlobalConfiguration.loadConfiguration((String)flinkConfDir).getString("historyserver.archive.fs.dir", "");
    }
}

