/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.git;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.git.GitCommit;
import io.hops.hopsworks.persistence.entity.git.GitRepository;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class GitCommitsFacade
extends AbstractFacade<GitCommit> {
    private static final Logger LOGGER = Logger.getLogger(GitCommitsFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public GitCommitsFacade() {
        super(GitCommit.class);
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public Optional<GitCommit> findByHashAndRepository(GitRepository repository) {
        TypedQuery query = this.em.createNamedQuery("GitCommit.findByCommitHashAndRepository", GitCommit.class);
        query.setParameter("repository", (Object)repository);
        query.setParameter("hash", (Object)repository.getCurrentCommit());
        query.setMaxResults(1);
        try {
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public AbstractFacade.CollectionInfo<GitCommit> getBranchCommits(GitRepository repository, String branch, Integer limit, Integer offset) {
        String queryStr = "SELECT gc FROM GitCommit gc WHERE gc.branch = :branch AND gc.repository = :repository ORDER BY gc.id";
        TypedQuery commitsQuery = this.em.createQuery(queryStr, GitCommit.class);
        commitsQuery.setParameter("branch", (Object)branch).setParameter("repository", (Object)repository);
        this.setOffsetAndLim(offset, limit, (Query)commitsQuery);
        Query countQuery = this.em.createQuery("SELECT COUNT(gc.id) FROM GitCommit gc WHERE gc.branch = :branch AND gc.repository = :repository");
        countQuery.setParameter("branch", (Object)branch).setParameter("repository", (Object)repository);
        return new AbstractFacade.CollectionInfo((Long)countQuery.getSingleResult(), commitsQuery.getResultList());
    }

    public void deleteAllInBranchAndRepository(String branch, GitRepository repository) {
        this.em.createNamedQuery("GitCommit.deleteAllForBranchAndRepository", GitCommit.class).setParameter("branch", (Object)branch).setParameter("repository", (Object)repository).executeUpdate();
    }

    public GitCommit create(GitCommit commit) {
        if (!Strings.isNullOrEmpty((String)commit.getMessage()) && commit.getMessage().length() > 1000) {
            commit.setMessage(commit.getMessage().substring(0, 995) + "...");
        }
        super.save((Object)commit);
        this.em.flush();
        return commit;
    }

    public AbstractFacade.CollectionInfo<String> getRepositoryBranches(GitRepository repository, Integer limit, Integer offset) {
        Query branchQuery = this.em.createNamedQuery("GitCommit.findBranchesForRepository").setParameter("repository", (Object)repository);
        this.setOffsetAndLim(offset, limit, branchQuery);
        Query allQuery = this.em.createNamedQuery("GitCommit.findBranchesForRepository").setParameter("repository", (Object)repository);
        List allBranches = allQuery.getResultList();
        return new AbstractFacade.CollectionInfo(Long.valueOf(allBranches.size()), branchQuery.getResultList());
    }
}

