/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.yarn;

import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.jobs.yarn.LogReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class YarnMonitor {
    private static final Logger LOGGER = Logger.getLogger(YarnMonitor.class.getName());

    public YarnApplicationState getApplicationState(YarnClient yarnClient, ApplicationId appId) throws YarnException, IOException {
        return yarnClient.getApplicationReport(appId).getYarnApplicationState();
    }

    public LogAggregationStatus getLogAggregationStatus(YarnClient yarnClient, ApplicationId appId) throws YarnException, IOException {
        return yarnClient.getApplicationReport(appId).getLogAggregationStatus();
    }

    public FinalApplicationStatus getFinalApplicationStatus(YarnClient yarnClient, ApplicationId appId) throws YarnException, IOException {
        return yarnClient.getApplicationReport(appId).getFinalApplicationStatus();
    }

    public float getProgress(YarnClient yarnClient, ApplicationId appId) throws YarnException, IOException {
        return yarnClient.getApplicationReport(appId).getProgress();
    }

    public void cancelJob(YarnClient yarnClient, ApplicationId appid) throws YarnException, IOException {
        yarnClient.killApplication(appid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyAggregatedYarnLogs(ApplicationId applicationId, DistributedFileSystemOps dfs, YarnClient yarnClient, String src, String dst, String[] desiredLogTypes) throws YarnException, IOException, InterruptedException {
        LogAggregationStatus logAggregationStatus = this.waitForLogAggregation(yarnClient, applicationId);
        if (logAggregationStatus == null) {
            return;
        }
        PrintStream writer = null;
        try {
            String[] srcs = this.getAggregatedLogFilePaths(src, dfs);
            if (!this.logFilesReady(srcs, dfs)) {
                LOGGER.log(Level.INFO, "Log is not ready for AppId: {0}. Will retry. ", applicationId);
            }
            writer = new PrintStream((OutputStream)dfs.create(dst));
            switch (logAggregationStatus) {
                case FAILED: {
                    writer.print("The log aggregation failed");
                    return;
                }
                case TIME_OUT: {
                    writer.print("*** WARNING: Log aggregation has timed-out for some of the containers\n\n\n");
                    for (String desiredLogType : desiredLogTypes) {
                        this.writeLogs(applicationId, dfs, srcs, writer, desiredLogType);
                    }
                    return;
                }
                case SUCCEEDED: {
                    for (String desiredLogType : desiredLogTypes) {
                        this.writeLogs(applicationId, dfs, srcs, writer, desiredLogType);
                    }
                    return;
                }
                default: {
                    writer.print("Something went wrong during log aggregation phase! Log aggregation status is: " + logAggregationStatus.name());
                    return;
                }
            }
        }
        catch (Exception ex) {
            if (writer != null) {
                writer.print(YarnMonitor.class.getName() + ": Failed to get aggregated logs.\n" + ex.getMessage());
            }
            LOGGER.log(Level.SEVERE, null, ex);
            return;
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    public LogAggregationStatus waitForLogAggregation(YarnClient yarnClient, ApplicationId appId) throws InterruptedException, YarnException, IOException {
        LogAggregationStatus logAggregationStatus = this.getLogAggregationStatus(yarnClient, appId);
        int not_startRetries = 0;
        while (!this.isFinal(logAggregationStatus)) {
            TimeUnit.SECONDS.sleep(2L);
            logAggregationStatus = this.getLogAggregationStatus(yarnClient, appId);
            if (!logAggregationStatus.equals((Object)LogAggregationStatus.NOT_START) || ++not_startRetries <= 30) continue;
            break;
        }
        return logAggregationStatus;
    }

    private boolean isFinal(LogAggregationStatus status) {
        if (status == null) {
            return true;
        }
        switch (status) {
            case RUNNING: 
            case RUNNING_WITH_FAILURE: 
            case NOT_START: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLogs(ApplicationId appId, DistributedFileSystemOps dfs, String[] srcs, PrintStream writer, String desiredLogType) {
        ArrayList<AggregatedLogFormat.LogKey> containerNames = new ArrayList<AggregatedLogFormat.LogKey>();
        LogReader reader = null;
        AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
        AggregatedLogFormat.ContainerLogsReader logReader = null;
        try {
            for (String src : srcs) {
                DataInputStream valueStream;
                Path location = new Path(src);
                LOGGER.log(Level.FINE, "Copying log from {0}", src);
                try {
                    reader = new LogReader(dfs.getConf(), dfs, location);
                    valueStream = reader.next(key);
                    while (valueStream != null) {
                        containerNames.add(key);
                        valueStream = reader.next(key);
                    }
                    reader.close();
                    reader = new LogReader(dfs.getConf(), dfs, location);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Logs are not available. Aggregation might not be done. AppId: {0}", appId);
                    if (reader != null) {
                        reader.close();
                    }
                    return;
                }
                try {
                    for (AggregatedLogFormat.LogKey containerKey : containerNames) {
                        valueStream = reader.next(key);
                        while (valueStream != null && !key.equals((Object)containerKey)) {
                            valueStream = reader.next(key);
                        }
                        if (valueStream != null) {
                            logReader = new AggregatedLogFormat.ContainerLogsReader(valueStream);
                        }
                        if (logReader == null) continue;
                        this.readContainerLogs(logReader, writer, desiredLogType, containerKey, location.getName());
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to get log. Aggregation might not be done. AppId: {0}", appId);
                }
                containerNames.clear();
                key = new AggregatedLogFormat.LogKey();
                logReader = null;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean logsReady(DistributedFileSystemOps dfs, String src) {
        DataInputStream valueStream;
        ArrayList<AggregatedLogFormat.LogKey> containerNames = new ArrayList<AggregatedLogFormat.LogKey>();
        LogReader reader = null;
        AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
        AggregatedLogFormat.ContainerLogsReader logReader = null;
        try {
            try {
                reader = new LogReader(dfs.getConf(), dfs, new Path(src));
                valueStream = reader.next(key);
                while (valueStream != null) {
                    containerNames.add(key);
                    valueStream = reader.next(key);
                }
                reader.close();
                reader = new LogReader(dfs.getConf(), dfs, new Path(src));
            }
            catch (IOException e) {
                boolean bl = false;
                if (reader == null) return bl;
                reader.close();
                return bl;
            }
        }
        catch (Throwable throwable) {
            if (reader == null) throw throwable;
            reader.close();
            throw throwable;
        }
        for (AggregatedLogFormat.LogKey containerKey : containerNames) {
            valueStream = reader.next(key);
            while (valueStream != null && !key.equals((Object)containerKey)) {
                valueStream = reader.next(key);
            }
            if (valueStream != null) {
                logReader = new AggregatedLogFormat.ContainerLogsReader(valueStream);
            }
            if (logReader == null || this.testLogs(logReader, "out")) continue;
            boolean bl = false;
            if (reader == null) return bl;
            reader.close();
            return bl;
        }
        {
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Error testing logs");
            }
        }
        if (reader == null) return true;
        reader.close();
        return true;
    }

    private boolean testLogs(AggregatedLogFormat.ContainerLogsReader logReader, String desiredLogType) throws IOException {
        boolean foundLog = true;
        String logType = logReader.nextLog();
        while (logType != null) {
            foundLog = true;
            if (!logType.contains(desiredLogType)) {
                foundLog = false;
            }
            logType = logReader.nextLog();
        }
        return foundLog;
    }

    private boolean readContainerLogs(AggregatedLogFormat.ContainerLogsReader logReader, PrintStream writer, String desiredLogType, AggregatedLogFormat.LogKey containerKey, String nodename) throws IOException {
        int bufferSize = 65536;
        char[] cbuf = new char[bufferSize];
        boolean foundLog = false;
        String logType = logReader.nextLog();
        while (logType != null) {
            if (desiredLogType == null || desiredLogType.isEmpty() || logType.contains(desiredLogType)) {
                int currentToRead;
                long logLength = logReader.getCurrentLogLength();
                if (!foundLog) {
                    writer.append("Container: ").append(containerKey.toString()).append(" on ").append(nodename).append("\n").append("===============================================").append("=============================================== \n");
                }
                if (logLength == 0L) {
                    writer.append("Log Type: ").append(logType).append("\n").append("Log Length: 0\n");
                    logType = logReader.nextLog();
                    continue;
                }
                writer.append("Log Type: ").append(logType).append("\n").append("Log Length: ").append(String.valueOf(logLength)).append("\n").append("Log Contents: \n");
                int len = 0;
                int n = currentToRead = logLength > (long)bufferSize ? bufferSize : (int)logLength;
                while (logLength > 0L && (len = logReader.read(cbuf, 0, currentToRead)) > 0) {
                    writer.append(new String(cbuf, 0, len));
                    currentToRead = (logLength -= (long)len) > (long)bufferSize ? bufferSize : (int)logLength;
                }
                writer.append("\n");
                foundLog = true;
            }
            logType = logReader.nextLog();
        }
        return foundLog;
    }

    private String[] getAggregatedLogFilePaths(String path, DistributedFileSystemOps dfs) throws IOException {
        Path location = new Path(path);
        if (!dfs.exists(path)) {
            String[] paths = new String[]{path};
            return paths;
        }
        if (!dfs.isDir(path)) {
            String[] paths = new String[]{path};
            return paths;
        }
        FileStatus[] fileStatus = dfs.listStatus(location);
        if (fileStatus == null || fileStatus.length == 0) {
            String[] paths = new String[]{path};
            return paths;
        }
        String[] paths = new String[fileStatus.length];
        for (int i = 0; i < fileStatus.length; ++i) {
            paths[i] = path + File.separator + fileStatus[i].getPath().getName();
        }
        return paths;
    }

    private boolean logFilesReady(String[] paths, DistributedFileSystemOps dfs) throws IOException {
        boolean ready = false;
        for (String path : paths) {
            Path location = new Path(path);
            if (!dfs.exists(path)) {
                return false;
            }
            if (dfs.isDir(path)) {
                return false;
            }
            FileStatus fileStatus = dfs.getFileStatus(location);
            if (fileStatus == null) {
                return false;
            }
            if (fileStatus.getLen() == 0L) {
                return false;
            }
            if (!this.logsReady(dfs, path)) {
                return false;
            }
            ready = true;
        }
        return ready;
    }
}

