/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.explicit;

import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.stream.StreamFeatureGroupDTO;
import io.hops.hopsworks.common.provenance.explicit.FeatureGroupLinkFacade;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.provenance.FeatureGroupLink;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeatureGroupLinkController {
    @EJB
    private FeatureGroupLinkFacade featureGroupLinkFacade;
    @EJB
    private FeaturestoreFacade featurestoreFacade;
    @EJB
    private FeaturegroupFacade featuregroupFacade;
    private static final Logger LOGGER = Logger.getLogger(FeatureGroupLinkController.class.getName());

    public Collection<FeatureGroupLink> createParentLinks(Featurestore featurestore, StreamFeatureGroupDTO featureGroupDTO, Featuregroup featureGroup) throws GenericException {
        if (featureGroupDTO.getParents() != null) {
            return this.createParentLinksInt(featurestore, featureGroup, featureGroupDTO.getParents());
        }
        return new ArrayList<FeatureGroupLink>();
    }

    public Collection<FeatureGroupLink> createParentLinks(Featurestore featurestore, CachedFeaturegroupDTO featureGroupDTO, Featuregroup featureGroup) throws GenericException {
        if (featureGroupDTO.getParents() != null) {
            return this.createParentLinksInt(featurestore, featureGroup, featureGroupDTO.getParents());
        }
        return new ArrayList<FeatureGroupLink>();
    }

    private Collection<FeatureGroupLink> createParentLinksInt(Featurestore featurestore, Featuregroup featureGroup, List<FeaturegroupDTO> parentFGs) throws GenericException {
        ArrayList<FeatureGroupLink> links = new ArrayList<FeatureGroupLink>();
        HashMap<Integer, Featurestore> featurestores = new HashMap<Integer, Featurestore>();
        featurestores.put(featurestore.getId(), featurestore);
        for (FeaturegroupDTO parentFG : parentFGs) {
            FeatureGroupLink link = new FeatureGroupLink();
            link.setFeatureGroup(featureGroup);
            link.setParentFeatureGroup((Featuregroup)this.featuregroupFacade.find(parentFG.getId()));
            Featurestore parentFeatureStore = (Featurestore)featurestores.get(parentFG.getFeaturestoreId());
            if (parentFeatureStore == null) {
                parentFeatureStore = (Featurestore)this.featurestoreFacade.find(parentFG.getFeaturestoreId());
                if (parentFeatureStore == null) {
                    throw new GenericException(RESTCodes.GenericErrorCode.ILLEGAL_ARGUMENT, Level.WARNING, "cannot create explicit link to a deleted feature group");
                }
                featurestores.put(parentFeatureStore.getId(), parentFeatureStore);
            }
            link.setParentFeatureStore(parentFeatureStore.getProject().getName());
            link.setParentFeatureGroupName(parentFG.getName());
            link.setParentFeatureGroupVersion(parentFG.getVersion());
            this.featureGroupLinkFacade.persist(link);
            links.add(link);
        }
        return links;
    }
}

