/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.state;

import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.provenance.core.PaginationParams;
import io.hops.hopsworks.common.provenance.state.ProvStateController;
import io.hops.hopsworks.common.provenance.state.ProvStateParamBuilder;
import io.hops.hopsworks.common.provenance.state.ProvStateParams;
import io.hops.hopsworks.common.provenance.state.ProvStateParser;
import io.hops.hopsworks.common.provenance.state.dto.ProvStateDTO;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ProvStateBuilder {
    @EJB
    private ProvStateController stateProvCtrl;
    @EJB
    private InodeController inodeController;

    public ProvStateDTO build(Project project, ProvStateParams stateParams, PaginationParams pagParams) throws ProvenanceException {
        Inode projectInode = this.inodeController.getProjectRoot(project.getName());
        ProvStateParamBuilder paramBuilder = new ProvStateParamBuilder().filterByField(ProvStateParser.FieldsP.PROJECT_I_ID, projectInode.getId()).filterByFields(stateParams.getFileStateFilterBy()).sortByFields(stateParams.getFileStateSortBy()).filterByXAttrs(stateParams.getExactXAttrParams()).filterLikeXAttrs(stateParams.getLikeXAttrParams()).hasXAttrs(stateParams.getFilterByHasXAttrs()).sortByXAttrs(stateParams.getXattrSortBy()).withExpansions(stateParams.getExpansions()).withAppExpansionFilter(stateParams.getAppExpansionParams()).paginate(pagParams.getOffset(), pagParams.getLimit());
        switch (stateParams.getReturnType()) {
            case LIST: {
                return this.stateProvCtrl.provFileStateList(projectInode, paramBuilder);
            }
            case COUNT: {
                return this.stateProvCtrl.provFileStateCount(projectInode, paramBuilder);
            }
        }
        throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.UNSUPPORTED, Level.INFO, "return type: " + (Object)((Object)stateParams.getReturnType()) + " is not managed");
    }
}

