/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.environment;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.python.library.LibraryInstaller;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.PythonException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class DockerImageController {
    private static final Logger LOG = Logger.getLogger(LibraryInstaller.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private ProjectUtils projectUtils;
    @EJB
    private OSProcessExecutor osProcessExecutor;

    @VisibleForTesting
    public DockerImageController(Settings settings, ProjectUtils projectUtils, OSProcessExecutor osProcessExecutor) {
        this.settings = settings;
        this.projectUtils = projectUtils;
        this.osProcessExecutor = osProcessExecutor;
    }

    public DockerImageController() {
    }

    public void buildImage(String dockerImageName, String dockerFilePath, File cwd) throws ServiceDiscoveryException, ServiceException {
        LOG.log(Level.FINEST, "project-dockerImage:" + dockerImageName);
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(this.settings.getSudoersDir() + "/dockerImage.sh").addCommand("create").addCommand(dockerFilePath).addCommand(this.projectUtils.getRegistryURL() + "/" + dockerImageName).redirectErrorStream(true).setCurrentWorkingDirectory(cwd).setWaitTimeout(1L, TimeUnit.HOURS).build();
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                String errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr() + "||\n";
                throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_IMAGE_CREATION_ERROR, Level.INFO, errorMsg);
            }
        }
        catch (IOException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_ERROR, Level.WARNING, "Could not initiate docker operation", "Error executing OSProcessExecutor-dockerImage.sh", (Throwable)e);
        }
    }

    public void buildImage(String dockerImageName, String dockerFilePath, File cwd, ArrayList<String> dockerBuildOpts) throws ServiceException, ServiceDiscoveryException {
        this.buildImage(dockerImageName, dockerFilePath, cwd, dockerBuildOpts, null, null);
    }

    public void buildImage(String dockerImageName, String dockerFilePath, File cwd, ArrayList<String> dockerBuildOpts, String gitApiKeyName, String gitApiToken) throws ServiceDiscoveryException, ServiceException {
        LOG.log(Level.FINEST, "project-nextDockerImageName:" + dockerImageName);
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(this.settings.getSudoersDir() + "/dockerImage.sh").addCommand("create").addCommand(dockerFilePath).addCommand(this.projectUtils.getRegistryURL() + "/" + dockerImageName).addCommand("'" + String.join((CharSequence)" ", dockerBuildOpts) + "'").redirectErrorStream(true).setCurrentWorkingDirectory(cwd).setWaitTimeout(1L, TimeUnit.HOURS).build();
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                if (!Strings.isNullOrEmpty((String)gitApiToken)) {
                    String stderr;
                    String errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode();
                    String stdout = processResult.getStdout();
                    if (stdout != null) {
                        errorMsg = errorMsg + " out: " + stdout.replaceAll(gitApiToken, gitApiKeyName + "_token");
                    }
                    if ((stderr = processResult.getStderr()) != null) {
                        errorMsg = errorMsg + "\n err: " + stderr.replaceAll(gitApiToken, gitApiKeyName + "_token");
                    }
                    errorMsg = errorMsg + "||\n";
                    throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_IMAGE_CREATION_ERROR, Level.INFO, errorMsg);
                }
                String errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr() + "||\n";
                throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_IMAGE_CREATION_ERROR, Level.INFO, errorMsg);
            }
        }
        catch (IOException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_ERROR, Level.WARNING, "Could not initiate docker operation", "Error executing OSProcessExecutor-dockerImage.sh", (Throwable)e);
        }
    }

    public String listLibraries(String dockerImage) throws ServiceException {
        String prog = this.settings.getSudoersDir() + "/dockerImage.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("list").addCommand(dockerImage).redirectErrorStream(true).setWaitTimeout(30L, TimeUnit.MINUTES).build();
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                String errorMsg = "Could not list libraries in the docker image. Retry the command or recreate the environment\n Exit code: " + processResult.getExitCode() + "\nout: " + processResult.getStdout() + "\nerr: " + processResult.getStderr() + "||\n";
                throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_ERROR, Level.INFO, errorMsg);
            }
            return processResult.getStdout();
        }
        catch (IOException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_ERROR, Level.WARNING, "Could not initiate docker operation", "Error executing OSProcessExecutor-dockerImage.sh", (Throwable)e);
        }
    }

    public String exportImage(String dockerImage) throws ServiceException {
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(this.settings.getSudoersDir() + "/dockerImage.sh").addCommand("export").addCommand(dockerImage).redirectErrorStream(true).setWaitTimeout(30L, TimeUnit.MINUTES).build();
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                String errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr() + "||\n";
                throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_ERROR, Level.INFO, errorMsg);
            }
            return processResult.getStdout();
        }
        catch (IOException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_ERROR, Level.WARNING, "Could not initiate docker operation", "Error executing OSProcessExecutor-dockerImage.sh", (Throwable)e);
        }
    }

    public String checkImage(String dockerImage) throws PythonException, ServiceException {
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(this.settings.getSudoersDir() + "/dockerImage.sh").addCommand("check").addCommand(dockerImage).redirectErrorStream(true).setWaitTimeout(300L, TimeUnit.SECONDS).build();
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() == 0) {
                return "";
            }
            if (processResult.getStdout() != null && (processResult.getStdout().contains("which is not installed") || processResult.getStdout().contains("has requirement"))) {
                return processResult.getStdout();
            }
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_PIP_CHECK_FAILED, Level.INFO, "Failed to run pip check: " + (Strings.isNullOrEmpty((String)processResult.getStdout()) ? "" : processResult.getStdout()));
        }
        catch (IOException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_ERROR, Level.WARNING, "Could not initiate docker operation", "Error executing OSProcessExecutor-dockerImage.sh", (Throwable)e);
        }
    }

    public void deleteImage(String dockerImage) throws ServiceException {
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(this.settings.getSudoersDir() + "/dockerImage.sh").addCommand("delete").addCommand(dockerImage).redirectErrorStream(true).setWaitTimeout(1L, TimeUnit.MINUTES).build();
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                String errorMsg = "Could not delete the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout();
                throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_ERROR, Level.INFO, errorMsg);
            }
        }
        catch (IOException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_ERROR, Level.WARNING, "Could not initiate docker operation", "Error executing OSProcessExecutor-dockerImage.sh", (Throwable)e);
        }
    }

    public void gcImages() throws ServiceException {
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(this.settings.getSudoersDir() + "/dockerImage.sh").addCommand("gc").redirectErrorStream(true).setWaitTimeout(5L, TimeUnit.MINUTES).build();
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                String errorMsg = "Could not delete the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr();
                throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_ERROR, Level.INFO, errorMsg);
            }
        }
        catch (IOException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_ERROR, Level.WARNING, "Could not initiate docker operation", "Error executing OSProcessExecutor-dockerImage.sh", (Throwable)e);
        }
    }

    public List<String> deleteACR(String repositoryName, String imageTagPrefix) throws ServiceDiscoveryException, ServiceException {
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(this.settings.getSudoersDir() + "/dockerImage.sh").addCommand("delete-acr").addCommand(this.projectUtils.getRegistryAddress()).addCommand(repositoryName).addCommand(imageTagPrefix).redirectErrorStream(true).setWaitTimeout(1L, TimeUnit.MINUTES).build();
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                String errorMsg = "Could not delete docker images in " + repositoryName + " under prefix " + imageTagPrefix + ". Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout();
                throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_ERROR, Level.INFO, errorMsg);
            }
            return Arrays.asList(processResult.getStdout().split("\n"));
        }
        catch (IOException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_ERROR, Level.WARNING, "Could not initiate docker operation", "Error executing OSProcessExecutor-dockerImage.sh", (Throwable)e);
        }
    }

    public List<String> listTagsACR(String repositoryName, String filter) throws ServiceDiscoveryException, ServiceException {
        String prog = this.settings.getSudoersDir() + "/dockerImage.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("list-tags-acr").addCommand(this.projectUtils.getRegistryAddress()).addCommand(repositoryName).addCommand(filter).redirectErrorStream(true).setWaitTimeout(1L, TimeUnit.MINUTES).build();
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                String errorMsg = "Failed to get the images tags from the repository";
                throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_ERROR, Level.INFO, errorMsg);
            }
            return Arrays.asList(processResult.getStdout().split("\n"));
        }
        catch (IOException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_ERROR, Level.WARNING, "Could not initiate docker operation", "Error executing OSProcessExecutor-dockerImage.sh", (Throwable)e);
        }
    }

    public Future<ProcessResult> tag(String baseImage, String targetImage) throws ServiceDiscoveryException, ServiceException {
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(this.settings.getSudoersDir() + "/dockerImage.sh").addCommand("tag").addCommand(this.projectUtils.getRegistryURL() + "/" + baseImage).addCommand(this.projectUtils.getRegistryURL() + "/" + targetImage).redirectErrorStream(true).setWaitTimeout(10L, TimeUnit.MINUTES).build();
        try {
            return this.osProcessExecutor.submit(processDescriptor);
        }
        catch (IOException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_ERROR, Level.WARNING, "Could not initiate docker operation", "Error executing OSProcessExecutor-dockerImage.sh", (Throwable)e);
        }
    }
}

