/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.environment;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.dao.command.SystemCommandFacade;
import io.hops.hopsworks.common.dao.host.HostsFacade;
import io.hops.hopsworks.common.proxies.client.HttpClient;
import io.hops.hopsworks.common.python.environment.DockerImageController;
import io.hops.hopsworks.common.python.environment.DockerRegistryMngr;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.command.Operation;
import io.hops.hopsworks.persistence.entity.command.SystemCommand;
import io.hops.hopsworks.persistence.entity.host.Hosts;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public abstract class DockerRegistryMngrImpl
implements DockerRegistryMngr {
    private static final Logger LOG = Logger.getLogger(DockerRegistryMngrImpl.class.getName());
    @EJB
    private ProjectUtils projectUtils;
    @EJB
    private SystemCommandFacade systemCommandFacade;
    @EJB
    private HostsFacade hostsFacade;
    @EJB
    private HttpClient httpClient;
    @EJB
    private DockerImageController dockerImageController;

    @Override
    public void deleteProjectDockerImage(String projectDockerImage) throws ServiceException, IOException, ServiceDiscoveryException {
        String projectDockerRepoName = this.projectUtils.getProjectDockerRepoName(projectDockerImage);
        List<String> projectTags = this.deleteProjectImagesOnRegistry(projectDockerImage);
        for (String tag : projectTags) {
            this.dockerImagesGC(this.projectUtils.getRegistryURL() + "/" + projectDockerRepoName + ":" + tag);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private final void dockerImagesGC(String image) {
        List allHosts = this.hostsFacade.findAll();
        for (Hosts host : allHosts) {
            SystemCommand condaGCCommand = new SystemCommand(host, Operation.CONDA_GC);
            condaGCCommand.setCommandArgumentsAsString(image);
            this.systemCommandFacade.persist(condaGCCommand);
        }
    }

    protected List<String> deleteProjectImagesOnRegistry(String projectDockerImage) throws ServiceDiscoveryException, IOException, ServiceException {
        String projectDockerImageNoTags = this.projectUtils.getProjectNameFromDockerImageName(projectDockerImage);
        URI registryURL = URI.create("https://" + this.projectUtils.getRegistryURL() + "/v2/" + projectDockerImageNoTags + "/tags/list");
        HttpGet request = new HttpGet(registryURL);
        request.setHeader("Content-Type", "application/json");
        HttpHost host = new HttpHost(registryURL.getHost(), registryURL.getPort(), registryURL.getScheme());
        String httpResp = (String)this.httpClient.execute(host, (HttpRequest)request, httpResponse -> {
            if (httpResponse.getStatusLine().getStatusCode() >= 400) {
                throw new IOException("Could not fetch tags from registry: " + httpResponse.getStatusLine().toString());
            }
            return EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        });
        ArrayList<String> projectImageTags = new ArrayList<String>();
        JSONObject respJson = new JSONObject(httpResp);
        if (respJson.has("tags") && respJson.get("tags") != "null") {
            JSONArray tagsJSON = new JSONObject(httpResp).getJSONArray("tags");
            for (int i = 0; i < tagsJSON.length(); ++i) {
                String tag = tagsJSON.get(i).toString();
                projectImageTags.add(tag);
                this.dockerImageController.deleteImage(projectDockerImageNoTags);
            }
        }
        return projectImageTags;
    }

    @Override
    public void runRegistryGC() throws ServiceException {
        this.dockerImageController.gcImages();
    }

    @Override
    public Map<String, Future<ProcessResult>> backupImages(String backupId) throws IOException, ServiceDiscoveryException, ServiceException {
        throw new UnsupportedOperationException("online backup only supported on cluster with managed repo");
    }

    @Override
    public Map<String, Future<ProcessResult>> restoreImages(String backupId) throws IOException, ServiceDiscoveryException, ServiceException {
        throw new UnsupportedOperationException("online backup only supported on cluster with managed repo");
    }

    @Override
    public List<String> deleteBackup(String backupId) throws ServiceDiscoveryException {
        throw new UnsupportedOperationException("online backup only supported on cluster with managed repo");
    }
}

