/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.upload;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;

public class UploadInfo
implements Serializable {
    private static final long serialVersionUID = 1313991374949049442L;
    private long resumableTotalSize;
    private long uploadedContentLength;
    private Date lastWrite;
    private HashSet<Integer> uploadedChunks = new HashSet();

    public UploadInfo() {
    }

    public UploadInfo(long resumableTotalSize) {
        this.resumableTotalSize = resumableTotalSize;
        this.lastWrite = new Date();
    }

    public long getResumableTotalSize() {
        return this.resumableTotalSize;
    }

    public void setResumableTotalSize(long resumableTotalSize) {
        this.resumableTotalSize = resumableTotalSize;
    }

    public long getUploadedContentLength() {
        return this.uploadedContentLength;
    }

    public void setUploadedContentLength(long uploadedContentLength) {
        this.uploadedContentLength = uploadedContentLength;
    }

    public HashSet<Integer> getUploadedChunks() {
        return this.uploadedChunks;
    }

    public void setUploadedChunks(HashSet<Integer> uploadedChunks) {
        this.uploadedChunks = uploadedChunks;
    }

    public boolean checkIfUploadFinished() {
        return this.uploadedContentLength == this.resumableTotalSize;
    }

    public Date getLastWrite() {
        return this.lastWrite;
    }

    public void setLastWrite(Date lastWrite) {
        this.lastWrite = lastWrite;
    }

    public boolean addChunkAndCheckIfFinished(int rcn, long contentLength) {
        if (this.uploadedChunks == null) {
            this.uploadedChunks = new HashSet();
        }
        if (!this.uploadedChunks.contains(rcn)) {
            this.uploadedContentLength += contentLength;
        }
        this.uploadedChunks.add(rcn);
        this.lastWrite = new Date();
        return this.checkIfUploadFinished();
    }

    public String toString() {
        return "UploadInfo{serialVersionUID=1313991374949049442, resumableTotalSize=" + this.resumableTotalSize + ", uploadedContentLength=" + this.uploadedContentLength + ", uploadedChunks=" + this.uploadedChunks + '}';
    }
}

