/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.serving.ServingConfig;
import io.hops.hopsworks.common.util.ConfigurationUtil;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.util.templates.ConfigProperty;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.configuration.flink.FlinkJobConfiguration;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.servicediscovery.HopsworksService;
import io.hops.hopsworks.servicediscovery.tags.OpenSearchTags;
import io.hops.hopsworks.servicediscovery.tags.ServiceTags;
import java.util.HashMap;
import java.util.Map;

public class FlinkConfigurationUtil
extends ConfigurationUtil {
    @Override
    public Map<String, String> setFrameworkProperties(Project project, JobConfiguration jobConfiguration, Settings settings, String hdfsUser, Users hopsworksUser, Map<String, String> extraJavaOptions, String kafkaBrokersString, String hopsworksRestEndpoint, ServingConfig servingConfig, ServiceDiscoveryController serviceDiscoveryController) throws ServiceDiscoveryException {
        FlinkJobConfiguration flinkJobConfiguration = (FlinkJobConfiguration)jobConfiguration;
        HashMap<String, ConfigProperty> flinkProps = new HashMap<String, ConfigProperty>();
        flinkProps.put("log4j.configurationFile", new ConfigProperty("log4j.configurationFile", HopsUtils.IGNORE, settings.getFlinkConfDir() + "log4j2.properties"));
        flinkProps.put("state.checkpoints.dir", new ConfigProperty("state.checkpoints.dir", HopsUtils.OVERWRITE, "hdfs://" + Utils.getProjectPath(project.getName()) + "Resources" + "/.flinkCheckpoints"));
        if (extraJavaOptions == null) {
            extraJavaOptions = new HashMap<String, String>();
        }
        extraJavaOptions.put("log4j.configurationFile", settings.getFlinkConfDir() + "log4j2.properties");
        extraJavaOptions.put("hopsworks.restendpoint", hopsworksRestEndpoint);
        extraJavaOptions.put("hopsutil.insecure", String.valueOf(settings.isHopsUtilInsecure()));
        extraJavaOptions.put("server.truststore", "server.truststore");
        String elasticEndpoint = (settings.isOpenSearchHTTPSEnabled() ? "https://" : "http://") + serviceDiscoveryController.constructServiceAddressWithPort(HopsworksService.OPENSEARCH.getNameWithTag((ServiceTags)OpenSearchTags.rest));
        extraJavaOptions.put("hopsworks.opensearch.endpoint", elasticEndpoint);
        extraJavaOptions.put("hopsworks.projectid", Integer.toString(project.getId()));
        extraJavaOptions.put("hopsworks.projectname", project.getName());
        extraJavaOptions.put("hopsworks.domain.truststore", "t_certificate");
        extraJavaOptions.put("hopsworks.projectuser", hdfsUser);
        extraJavaOptions.put("hopsworks.kafka.brokeraddress", kafkaBrokersString);
        extraJavaOptions.put("hopsworks.job.type", jobConfiguration.getJobType().name());
        if (jobConfiguration.getAppName() != null) {
            extraJavaOptions.put("hopsworks.job.name", jobConfiguration.getAppName());
        }
        extraJavaOptions.put("log.file", "$LOG_DIRS/flink_log/output.log");
        extraJavaOptions.put("web.log.path", "$LOG_DIRS/flink_log/output.log");
        extraJavaOptions.put("taskmanager.log.path", "$LOG_DIRS/flink_log/output.log");
        StringBuilder extraJavaOptionsSb = new StringBuilder();
        for (String key : extraJavaOptions.keySet()) {
            extraJavaOptionsSb.append(" -D").append(key).append("=").append(extraJavaOptions.get(key));
        }
        flinkProps.put("env.java.opts", new ConfigProperty("env.java.opts", HopsUtils.APPEND_SPACE, extraJavaOptionsSb.toString()));
        Map<String, String> validatedFlinkProperties = HopsUtils.parseUserProperties(flinkJobConfiguration.getProperties());
        return HopsUtils.mergeHopsworksAndUserParams(flinkProps, validatedFlinkProperties);
    }
}

