/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.explicit;

import io.hops.hopsworks.common.provenance.explicit.FeatureViewLinkFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetFeature;
import io.hops.hopsworks.persistence.entity.provenance.FeatureViewLink;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeatureViewLinkController {
    @EJB
    private FeatureViewLinkFacade featureViewLinkFacade;
    private static final Logger LOGGER = Logger.getLogger(FeatureViewLinkController.class.getName());

    public Collection<FeatureViewLink> createParentLinks(FeatureView featureView) {
        HashMap<Integer, FeatureViewLink> links = new HashMap<Integer, FeatureViewLink>();
        for (TrainingDatasetFeature parentFG : featureView.getFeatures()) {
            if (links.containsKey(parentFG.getFeatureGroup().getId())) continue;
            FeatureViewLink link = new FeatureViewLink();
            link.setFeatureView(featureView);
            link.setParentFeatureGroup(parentFG.getFeatureGroup());
            link.setParentFeatureStore(parentFG.getFeatureGroup().getFeaturestore().getProject().getName());
            link.setParentFeatureGroupName(parentFG.getFeatureGroup().getName());
            link.setParentFeatureGroupVersion(parentFG.getFeatureGroup().getVersion());
            this.featureViewLinkFacade.persist(link);
            links.put(parentFG.getFeatureGroup().getId(), link);
        }
        return links.values();
    }
}

