/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import io.hops.hopsworks.common.featurestore.xattr.dto.FeatureViewXAttrDTO;
import io.hops.hopsworks.common.featurestore.xattr.dto.FeaturegroupXAttr;
import io.hops.hopsworks.common.featurestore.xattr.dto.TrainingDatasetXAttrDTO;
import io.hops.hopsworks.common.provenance.core.dto.ProvCoreDTO;
import io.hops.hopsworks.common.provenance.core.dto.ProvTypeDTO;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.PostConstruct;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NEVER)
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class HopsworksJAXBContext {
    private JAXBContext context;

    @PostConstruct
    public void init() {
        try {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("eclipselink.json.include-root", false);
            properties.put("eclipselink.media-type", "application/json");
            this.context = JAXBContextFactory.createContext((Class[])new Class[]{ProvCoreDTO.class, ProvTypeDTO.class, FeaturegroupXAttr.FullDTO.class, FeaturegroupXAttr.SimplifiedDTO.class, FeaturegroupXAttr.SimpleFeatureDTO.class, TrainingDatasetXAttrDTO.class, FeatureViewXAttrDTO.class}, properties);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public <V> String marshal(V obj) throws GenericException {
        try {
            Marshaller marshaller = this.context.createMarshaller();
            StringWriter sw = new StringWriter();
            marshaller.marshal(obj, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new GenericException(RESTCodes.GenericErrorCode.ILLEGAL_STATE, Level.INFO, "jaxb marshal exception");
        }
    }

    public <V> V unmarshal(String json, Class<V> type) throws GenericException {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            StreamSource ss = new StreamSource(new StringReader(json));
            return (V)unmarshaller.unmarshal((Source)ss, type).getValue();
        }
        catch (JAXBException e) {
            String errMsg = "jaxb unmarshall exception";
            throw new GenericException(RESTCodes.GenericErrorCode.ILLEGAL_STATE, Level.INFO, errMsg, errMsg, (Throwable)e);
        }
    }

    public <V> List<V> unmarshalList(String json, Class<V> type) throws GenericException {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            StreamSource ss = new StreamSource(new StringReader(json));
            JAXBElement e = unmarshaller.unmarshal((Source)ss, type);
            return (List)e.getValue();
        }
        catch (JAXBException e) {
            throw new GenericException(RESTCodes.GenericErrorCode.ILLEGAL_STATE, Level.INFO, "jaxb unmarshall exception");
        }
    }
}

