/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.project.alert;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertSeverity;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertType;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.alert.ProjectServiceAlert;
import io.hops.hopsworks.persistence.entity.project.alert.ProjectServiceAlertStatus;
import io.hops.hopsworks.persistence.entity.project.service.ProjectServiceEnum;
import io.hops.hopsworks.persistence.entity.user.activity.Activity;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.util.Date;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class ProjectServiceAlertsFacade
extends AbstractFacade<ProjectServiceAlert> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public ProjectServiceAlertsFacade() {
        super(ProjectServiceAlert.class);
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public ProjectServiceAlert findByProjectAndId(Project project, Integer id) {
        TypedQuery query = this.em.createNamedQuery("ProjectServiceAlert.findByProjectAndId", ProjectServiceAlert.class);
        query.setParameter("project", (Object)project).setParameter("id", (Object)id);
        try {
            return (ProjectServiceAlert)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public ProjectServiceAlert findByProjectAndStatus(Project project, ProjectServiceAlertStatus status) {
        TypedQuery query = this.em.createNamedQuery("ProjectServiceAlert.findByProjectAndStatus", ProjectServiceAlert.class);
        query.setParameter("project", (Object)project).setParameter("status", (Object)status);
        try {
            return (ProjectServiceAlert)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public AbstractFacade.CollectionInfo findAllProjectAlerts(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort, Project project) {
        String queryStr = this.buildQuery("SELECT a FROM ProjectServiceAlert a ", filter, sort, "a.project = :project ");
        String queryCountStr = this.buildQuery("SELECT COUNT(a.id) FROM ProjectServiceAlert a ", filter, sort, "a.project = :project ");
        TypedQuery query = this.em.createQuery(queryStr, Activity.class).setParameter("project", (Object)project);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, Activity.class).setParameter("project", (Object)project);
        return this.findAll(offset, limit, filter, (Query)query, (Query)queryCount);
    }

    private AbstractFacade.CollectionInfo findAll(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Query query, Query queryCount) {
        this.setFilter(filter, query);
        this.setFilter(filter, queryCount);
        this.setOffsetAndLim(offset, limit, query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case TYPE: {
                q.setParameter(filterBy.getField(), (Object)this.getEnumValues(filterBy, AlertType.class));
                break;
            }
            case STATUS: {
                q.setParameter(filterBy.getField(), (Object)this.getEnumValues(filterBy, ProjectServiceAlertStatus.class));
                break;
            }
            case SEVERITY: {
                q.setParameter(filterBy.getField(), (Object)this.getEnumValues(filterBy, AlertSeverity.class));
                break;
            }
            case SERVICE: {
                q.setParameter(filterBy.getField(), (Object)this.getEnumValues(filterBy, ProjectServiceEnum.class));
                break;
            }
            case CREATED: 
            case CREATED_GT: 
            case CREATED_LT: {
                Date date = this.getDate(filterBy.getField(), filterBy.getParam());
                q.setParameter(filterBy.getField(), (Object)date);
                break;
            }
        }
    }

    public static enum Filters {
        TYPE("TYPE", "a.alertType IN :alertType ", "alertType", AlertType.PROJECT_ALERT.toString()),
        STATUS("STATUS", "a.status IN :status ", "status", ProjectServiceAlertStatus.JOB_FAILED.toString()),
        SEVERITY("SEVERITY", "a.severity IN :severity ", "severity", AlertSeverity.INFO.toString()),
        SERVICE("SERVICE", "a.service IN :service ", "service", ProjectServiceEnum.JOBS.toString()),
        CREATED("CREATED", "a.created = :created ", "created", ""),
        CREATED_GT("DATE_CREATED_GT", "a.created > :createdFrom ", "createdFrom", ""),
        CREATED_LT("DATE_CREATED_LT", "a.created < :createdTo ", "createdTo", "");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", "a.id ", "ASC"),
        TYPE("TYPE", "a.alertType ", "ASC"),
        STATUS("STATUS", "a.status ", "ASC"),
        SEVERITY("SEVERITY", "a.severity ", "ASC"),
        CREATED("CREATED", "a.created ", "DESC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }
}

