/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.core.opensearch;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.hops.hopsworks.common.opensearch.OpenSearchClientController;
import io.hops.hopsworks.common.provenance.core.opensearch.OpenSearchHelper;
import io.hops.hopsworks.exceptions.OpenSearchException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
public class OpenSearchCache {
    private static final Logger LOG = Logger.getLogger(OpenSearchCache.class.getName());
    @EJB
    private OpenSearchClientController client;
    private Cache<String, Map<String, String>> indexMappings;

    @PostConstruct
    private void initClient() {
        this.indexMappings = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(50L).build();
    }

    @Lock(value=LockType.READ)
    public void cacheMapping(String index, Map<String, String> mapping) {
        this.indexMappings.put((Object)index, mapping);
    }

    @Lock(value=LockType.READ)
    public Map<String, String> getMapping(String index) {
        return (Map)this.indexMappings.getIfPresent((Object)index);
    }

    @Lock(value=LockType.READ)
    public void clearMapping(String index) {
        this.indexMappings.invalidate((Object)index);
    }

    public Map<String, String> mngIndexGetMapping(String index, boolean forceFetch) throws OpenSearchException {
        Map<String, String> mapping;
        if (forceFetch) {
            this.clearMapping(index);
        }
        if ((mapping = this.getMapping(index)) == null) {
            try {
                Map<String, Map<String, String>> result = this.client.mngIndexGetMappings(index);
                mapping = result.get(index);
                if (mapping != null) {
                    this.cacheMapping(index, mapping);
                }
            }
            catch (OpenSearchException e) {
                if (OpenSearchHelper.indexNotFound(e.getCause())) {
                    return new HashMap<String, String>();
                }
                throw e;
            }
        }
        return mapping;
    }
}

