/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.yarn;

import io.hops.hopsworks.common.security.BaseHadoopClientsService;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.yarn.YarnClientWrapper;
import io.hops.hopsworks.exceptions.CryptoPasswordNotFoundException;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.net.HopsSSLSocketFactory;

@Stateless
public class YarnClientService {
    private final Logger LOG = Logger.getLogger(YarnClientService.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private BaseHadoopClientsService bhcs;
    private Configuration conf;
    private String transientDir;

    @PostConstruct
    public void init() {
        File yarnSite;
        String confDir = this.settings.getHadoopConfDir();
        File coreSite = new File(confDir, "core-site.xml");
        if (!coreSite.exists()) {
            this.handleMissingConf("core-site.xml", confDir);
        }
        if (!(yarnSite = new File(confDir, "yarn-site.xml")).exists()) {
            this.handleMissingConf("yarn-site.xml", confDir);
        }
        this.conf = new Configuration();
        Path coreSitePath = new Path(coreSite.getAbsolutePath());
        Path yarnSitePath = new Path(yarnSite.getAbsolutePath());
        this.conf.addResource(coreSitePath);
        this.conf.addResource(yarnSitePath);
        if (this.settings.getHopsRpcTls()) {
            this.transientDir = this.settings.getHopsworksTmpCertDir();
        }
    }

    @PreDestroy
    public void tearDown() {
        this.conf.clear();
        this.conf = null;
    }

    public YarnClientWrapper getYarnClient(String username) {
        if (this.settings.getHopsRpcTls()) {
            try {
                Configuration newConf = new Configuration(this.conf);
                this.bhcs.materializeCertsForNonSuperUser(username);
                this.bhcs.configureTlsForProjectSpecificUser(username, this.transientDir, newConf);
                return this.createYarnClient(username, newConf);
            }
            catch (CryptoPasswordNotFoundException ex) {
                this.LOG.log(Level.SEVERE, ex.getMessage(), ex);
                this.bhcs.removeNonSuperUserCertificate(username);
                return null;
            }
        }
        return this.createYarnClient(username, this.conf);
    }

    public YarnClientWrapper getYarnClientSuper() {
        return this.getYarnClientSuper(null);
    }

    public YarnClientWrapper getYarnClientSuper(Configuration conf) {
        if (this.settings.getHopsRpcTls()) {
            Configuration newConfig = null != conf ? new Configuration(conf) : new Configuration(this.conf);
            String keystorePath = this.bhcs.getSuperKeystorePath();
            String keystorePass = this.bhcs.getSuperKeystorePassword();
            String truststorePath = this.bhcs.getSuperTrustStorePath();
            String truststorePass = this.bhcs.getSuperTrustStorePassword();
            HopsSSLSocketFactory.setTlsConfiguration((String)keystorePath, (String)keystorePass, (String)truststorePath, (String)truststorePass, (Configuration)newConfig);
            return this.createYarnClient(null, newConfig);
        }
        return null != conf ? this.createYarnClient(null, conf) : this.createYarnClient(null, this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeYarnClient(YarnClientWrapper yarnClientWrapper) {
        if (null != yarnClientWrapper) {
            try {
                yarnClientWrapper.close();
            }
            finally {
                if (this.settings.getHopsRpcTls()) {
                    String username = yarnClientWrapper.getUsername();
                    String projectName = yarnClientWrapper.getProjectName();
                    if (null != username && null != projectName) {
                        String effectiveUsername = projectName + "__" + username;
                        this.bhcs.removeNonSuperUserCertificate(effectiveUsername);
                    }
                }
            }
        }
    }

    private void handleMissingConf(String confName, String confDir) throws IllegalStateException {
        this.LOG.log(Level.SEVERE, "Unable to locate {0} in {1}", new Object[]{confName, confDir});
        throw new IllegalStateException("Unable to locate " + confName + " in " + confDir);
    }

    private YarnClientWrapper createYarnClient(String username, Configuration conf) {
        String[] tokens;
        if (null != username && (tokens = username.split("__", 2)).length == 2) {
            return new YarnClientWrapper(tokens[0], tokens[1], conf).get();
        }
        return new YarnClientWrapper(null, null, conf).get();
    }
}

