/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featureview;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.QueryParam;
import io.hops.hopsworks.common.featurestore.featureview.FeatureViewFilterBy;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class FeatureViewFacade
extends AbstractFacade<FeatureView> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeatureViewFacade() {
        super(FeatureView.class);
    }

    public List<FeatureView> findAll() {
        TypedQuery q = this.em.createNamedQuery("FeatureView.findAll", FeatureView.class);
        return q.getResultList();
    }

    public List<FeatureView> findByFeaturestore(Featurestore featurestore, QueryParam queryParam) {
        Boolean latestVersion = false;
        if (queryParam != null && queryParam.getFilters().removeIf(filter -> filter.toString().equals("LATEST_VERSION"))) {
            latestVersion = true;
        }
        HashMap<String, Object> extraParam = new HashMap<String, Object>();
        extraParam.put("featurestore", featurestore);
        String queryStr = this.buildQuery("SELECT fv FROM FeatureView fv ", queryParam != null ? queryParam.getFilters() : null, queryParam != null ? queryParam.getSorts() : null, "fv.featurestore = :featurestore ");
        Query q = this.makeQuery(queryStr, queryParam, extraParam);
        List<FeatureView> results = q.getResultList();
        if (latestVersion.booleanValue()) {
            results = this.retainLatestVersion(results);
        }
        return results;
    }

    public Long countByFeaturestore(Featurestore featurestore) {
        return (Long)this.em.createNamedQuery("FeatureView.countByFeaturestore", Long.class).setParameter("featurestore", (Object)featurestore).getSingleResult();
    }

    List<FeatureView> retainLatestVersion(List<FeatureView> featureViews) {
        HashMap<String, FeatureView> latestVersion = new HashMap<String, FeatureView>();
        for (FeatureView featureView : featureViews) {
            if (!latestVersion.containsKey(featureView.getName())) {
                latestVersion.put(featureView.getName(), featureView);
                continue;
            }
            if (!latestVersion.containsKey(featureView.getName()) || featureView.getVersion() <= ((FeatureView)latestVersion.get(featureView.getName())).getVersion()) continue;
            latestVersion.put(featureView.getName(), featureView);
        }
        return new ArrayList<FeatureView>(latestVersion.values());
    }

    public List<FeatureView> findByNameAndFeaturestore(String name, Featurestore featurestore) {
        QueryParam queryParam = new QueryParam();
        return this.findByNameAndFeaturestore(name, featurestore, queryParam);
    }

    public List<FeatureView> findByNameAndFeaturestore(String name, Featurestore featurestore, QueryParam queryParam) {
        Set<AbstractFacade.FilterBy> filters = queryParam.getFilters();
        filters.add(new FeatureViewFilterBy("name", name, "name1"));
        return this.findByFeaturestore(featurestore, queryParam);
    }

    public List<FeatureView> findByNameVersionAndFeaturestore(String name, Integer version, Featurestore featurestore) {
        QueryParam queryParam = new QueryParam();
        return this.findByNameVersionAndFeaturestore(name, version, featurestore, queryParam);
    }

    public List<FeatureView> findByNameVersionAndFeaturestore(String name, Integer version, Featurestore featurestore, QueryParam queryParam) {
        Set<AbstractFacade.FilterBy> filters = queryParam.getFilters();
        filters.add(new FeatureViewFilterBy("name", name, "name1"));
        filters.add(new FeatureViewFilterBy("version", version.toString(), "version1"));
        return this.findByFeaturestore(featurestore, queryParam);
    }

    public Integer findLatestVersion(String name, Featurestore featurestore) {
        TypedQuery query = this.em.createNamedQuery("FeatureView.findByFeaturestoreAndNameOrderedByDescVersion", FeatureView.class);
        query.setParameter("name", (Object)name);
        query.setParameter("featurestore", (Object)featurestore);
        List results = query.getResultList();
        if (results != null && !results.isEmpty()) {
            return ((FeatureView)results.get(0)).getVersion();
        }
        return null;
    }

    private Query makeQuery(String queryStr, QueryParam queryParam, Map<String, Object> extraParam) {
        TypedQuery query = this.em.createQuery(queryStr, FeatureView.class);
        if (queryParam != null) {
            this.setFilter(queryParam.getFilters(), (Query)query);
            this.setOffsetAndLim(queryParam.getOffset(), queryParam.getLimit(), (Query)query);
        }
        if (extraParam != null) {
            for (Map.Entry<String, Object> item : extraParam.entrySet()) {
                query.setParameter(item.getKey(), item.getValue());
            }
        }
        return query;
    }

    private void setFilter(Set<AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy aFilter : filter) {
            this.setFilterQuery(aFilter, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.toString())) {
            case NAME: {
                q.setParameter(filterBy.getParam(), (Object)filterBy.getValue());
                break;
            }
            case VERSION: {
                q.setParameter(filterBy.getParam(), (Object)Integer.valueOf(filterBy.getValue()));
                break;
            }
        }
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public static enum Sorts {
        NAME("ID", "fv.name ", "ASC"),
        VERSION("VERSION", "fv.version ", "ASC"),
        CREATION("CREATION", "fv.created ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Filters {
        NAME("NAME", String.format("%s.name = :%%s ", "fv"), "name", ""),
        VERSION("VERSION", String.format("%s.version = :%%s ", "fv"), "version", ""),
        LATEST_VERSION("LATEST_VERSION", null, null, null);

        private final String name;
        private final String sql;
        private final String field;
        private final String defaultValue;

        private Filters(String name, String sql, String field, String defaultValue) {
            this.name = name;
            this.sql = sql;
            this.field = field;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.name;
        }
    }
}

