/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.commands.featurestore.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum OpenSearchDocType {
    FEATURE_GROUP("featuregroup"),
    FEATURE_VIEW("featureview"),
    TRAINING_DATASET("trainingdataset");

    private String value;

    private OpenSearchDocType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static OpenSearchDocType getByValue(String value) {
        if (value != null) {
            for (OpenSearchDocType status : OpenSearchDocType.values()) {
                if (!status.value.equals(value)) continue;
                return status;
            }
            throw new IllegalArgumentException("Unknown search doc type '" + value + "'");
        }
        return null;
    }
}

