/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.statistics.columns;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.StatisticColumn;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.validation.ConstraintViolationException;

@Stateless
public class StatisticColumnFacade
extends AbstractFacade<StatisticColumn> {
    private static final Logger LOGGER = Logger.getLogger(StatisticColumnFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public StatisticColumnFacade() {
        super(StatisticColumn.class);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void persist(StatisticColumn statisticColumn) {
        try {
            this.em.persist((Object)statisticColumn);
            this.em.flush();
        }
        catch (ConstraintViolationException cve) {
            LOGGER.log(Level.WARNING, "Could not persist the new StatisticColumn", cve);
            throw cve;
        }
    }

    public List<StatisticColumn> findByFeaturegroup(Featuregroup featuregroup) {
        return this.em.createNamedQuery("StatisticColumn.findByFeaturegroup", StatisticColumn.class).setParameter("feature_group", (Object)featuregroup).getResultList();
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }
}

