/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util.templates;

import io.hops.hopsworks.common.util.templates.ConfigReplacementPolicy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigProperty {
    private static final Logger LOG = Logger.getLogger(ConfigProperty.class.getName());
    private final String replacementPattern;
    private final ConfigReplacementPolicy replacementPolicy;
    private String value;

    public ConfigProperty(String replacementPattern, ConfigReplacementPolicy replacementPolicy, String value) {
        this.replacementPattern = replacementPattern;
        this.replacementPolicy = replacementPolicy;
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getReplacementPattern() {
        return this.replacementPattern;
    }

    public void replaceValue(String newValue) {
        if (this.replacementPolicy != null) {
            LOG.log(Level.FINE, "Replace policy: " + this.replacementPolicy.getClass().getName() + " " + this.value + " -> " + newValue);
            this.value = this.replacementPolicy.replace(this.value, newValue);
        } else {
            LOG.log(Level.WARNING, "Replacement policy is NULL");
        }
    }

    public String toString() {
        return "ConfigProperty{replacementPattern='" + this.replacementPattern + '\'' + ", replacementPolicy=" + this.replacementPolicy + ", value='" + this.value + '\'' + '}';
    }
}

