/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.featurestore.metadata;

import io.hops.hopsworks.common.dao.featurestore.metadata.FeatureStoreMetadataFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.metadata.FeatureStoreTag;
import io.hops.hopsworks.persistence.entity.featurestore.metadata.TagSchemas;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;

@Stateless
public class FeatureStoreTagFacade
extends FeatureStoreMetadataFacade<FeatureStoreTag> {
    private static final String SCHEMA = "schema";

    public FeatureStoreTagFacade() {
        super(FeatureStoreTag.class);
    }

    public Collector<FeatureStoreTag, ?, Map<String, String>> tagAsStringMapCollector() {
        return Collectors.toMap(t -> t.getSchema().getName(), FeatureStoreTag::getValue);
    }

    public Optional<FeatureStoreTag> findBySchema(Featuregroup fg, TagSchemas schema) {
        return this.findBySchema("featureGroup", fg, schema);
    }

    public Optional<FeatureStoreTag> findBySchema(FeatureView fv, TagSchemas schema) {
        return this.findBySchema("featureView", fv, schema);
    }

    public Optional<FeatureStoreTag> findBySchema(TrainingDataset td, TagSchemas schema) {
        return this.findBySchema("trainingDataset", td, schema);
    }

    private Optional<FeatureStoreTag> findBySchema(String artifactType, Object artifact, TagSchemas schema) {
        String queryStr = "SELECT m FROM " + this.getTableName() + " m";
        queryStr = queryStr + " WHERE m." + artifactType + " = :" + "id";
        queryStr = queryStr + " AND m.schema = :schema";
        TypedQuery query = this.em.createQuery(queryStr, this.entityClass);
        query.setParameter("id", artifact);
        query.setParameter(SCHEMA, (Object)schema);
        try {
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public int deleteBySchema(Featuregroup fg, TagSchemas schema) {
        return this.deleteBySchema("featureGroup", fg, schema);
    }

    public int deleteBySchema(FeatureView fv, TagSchemas schema) {
        return this.deleteBySchema("featureView", fv, schema);
    }

    public int deleteBySchema(TrainingDataset td, TagSchemas schema) {
        return this.deleteBySchema("trainingDataset", td, schema);
    }

    private int deleteBySchema(String artifactType, Object artifact, TagSchemas schema) {
        String queryStr = "DELETE FROM " + this.getTableName() + " m";
        queryStr = queryStr + " WHERE m." + artifactType + " = :" + "id";
        queryStr = queryStr + " AND m.schema = :schema";
        TypedQuery query = this.em.createQuery(queryStr, this.entityClass);
        query.setParameter("id", artifact);
        query.setParameter(SCHEMA, (Object)schema);
        return query.executeUpdate();
    }

    @Override
    public String getTableName() {
        return "FeatureStoreTag";
    }
}

