/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.validation.ConstraintViolationException;

@Stateless
public class FeaturestoreFacade
extends AbstractFacade<Featurestore> {
    private static final Logger LOGGER = Logger.getLogger(FeaturestoreFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeaturestoreFacade() {
        super(Featurestore.class);
    }

    public List<Featurestore> findAll() {
        TypedQuery q = this.em.createNamedQuery("Featurestore.findAll", Featurestore.class);
        return q.getResultList();
    }

    public List<Featurestore> findByProject(Project project) {
        TypedQuery q = this.em.createNamedQuery("Featurestore.findByProject", Featurestore.class).setParameter("project", (Object)project);
        return q.getResultList();
    }

    public Featurestore findById(Integer id) {
        try {
            return (Featurestore)this.em.createNamedQuery("Featurestore.findById", Featurestore.class).setParameter("id", (Object)id).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void persist(Featurestore featurestore) {
        try {
            this.em.persist((Object)featurestore);
            this.em.flush();
        }
        catch (ConstraintViolationException cve) {
            LOGGER.log(Level.WARNING, "Could not persist the new Featurestore", cve);
            throw cve;
        }
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }
}

