/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.topic.ITopic;
import io.hops.hopsworks.common.dao.command.SystemCommandFacade;
import io.hops.hopsworks.common.dao.host.HostsFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.message.MessageController;
import io.hops.hopsworks.common.security.CertificateMasterPwdMgm;
import io.hops.hopsworks.common.security.MasterPasswordChangeResult;
import io.hops.hopsworks.common.security.MasterPasswordHandler;
import io.hops.hopsworks.common.security.MasterPasswordResetResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.EncryptionMasterPasswordException;
import io.hops.hopsworks.persistence.entity.command.Operation;
import io.hops.hopsworks.persistence.entity.command.SystemCommand;
import io.hops.hopsworks.persistence.entity.host.Hosts;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.Asynchronous;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
public class CertificatesMgmService {
    private final Logger LOG = Logger.getLogger(CertificatesMgmService.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private UserFacade userFacade;
    @EJB
    private MessageController messageController;
    @EJB
    private SystemCommandFacade systemCommandFacade;
    @EJB
    private HostsFacade hostsFacade;
    @Inject
    @Any
    private Instance<MasterPasswordHandler> handlers;
    @Inject
    private HazelcastInstance hazelcastInstance;
    @EJB
    private CertificateMasterPwdMgm certificateMasterPwdMgm;
    private File masterPasswordFile;
    private final Map<Class, MasterPasswordChangeResult> handlersResult = new HashMap<Class, MasterPasswordChangeResult>();
    private Cache<Integer, UPDATE_STATUS> updateStatus;
    private Random rand;
    private ITopic<String> masterPasswordUpdatedTopic;
    private static final String MAP_NAME = "certificatesMgmUpdateStatus";
    public static final String PASSWORD_UPDATED_TOPIC_NAME = "masterPasswordUpdated";

    private void initHazelcast() {
        if (this.hazelcastInstance != null) {
            if (this.hazelcastInstance.getConfig().getMapConfigOrNull(MAP_NAME) == null) {
                MapConfig mapConfig = new MapConfig(MAP_NAME);
                mapConfig.setMaxIdleSeconds((int)TimeUnit.HOURS.toSeconds(12L));
                this.hazelcastInstance.getConfig().addMapConfig(mapConfig);
            }
            this.masterPasswordUpdatedTopic = this.hazelcastInstance.getReliableTopic(PASSWORD_UPDATED_TOPIC_NAME);
        } else {
            this.updateStatus = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(12L, TimeUnit.HOURS).build();
        }
    }

    private UPDATE_STATUS getIfPresentUpdateStatusCache(Integer key) {
        if (this.hazelcastInstance != null) {
            IMap map = this.hazelcastInstance.getMap(MAP_NAME);
            return (UPDATE_STATUS)((Object)map.get((Object)key));
        }
        return (UPDATE_STATUS)((Object)this.updateStatus.getIfPresent((Object)key));
    }

    private void putUpdateStatusCache(Integer key, UPDATE_STATUS val) {
        if (this.hazelcastInstance != null) {
            IMap map = this.hazelcastInstance.getMap(MAP_NAME);
            map.put((Object)key, (Object)val);
        } else {
            this.updateStatus.put((Object)key, (Object)val);
        }
    }

    @PostConstruct
    public void init() {
        this.masterPasswordFile = new File(this.settings.getHopsworksMasterEncPasswordFile());
        if (!this.masterPasswordFile.exists()) {
            throw new IllegalStateException("Master encryption file does not exist");
        }
        try {
            PosixFileAttributeView fileView = Files.getFileAttributeView(this.masterPasswordFile.toPath(), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            Set<PosixFilePermission> filePermissions = fileView.readAttributes().permissions();
            boolean ownerRead = filePermissions.contains((Object)PosixFilePermission.OWNER_READ);
            boolean ownerWrite = filePermissions.contains((Object)PosixFilePermission.OWNER_WRITE);
            boolean ownerExecute = filePermissions.contains((Object)PosixFilePermission.OWNER_EXECUTE);
            boolean groupRead = filePermissions.contains((Object)PosixFilePermission.GROUP_READ);
            boolean groupWrite = filePermissions.contains((Object)PosixFilePermission.GROUP_WRITE);
            boolean groupExecute = filePermissions.contains((Object)PosixFilePermission.GROUP_EXECUTE);
            boolean othersRead = filePermissions.contains((Object)PosixFilePermission.OTHERS_READ);
            boolean othersWrite = filePermissions.contains((Object)PosixFilePermission.OTHERS_WRITE);
            boolean othersExecute = filePermissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE);
            if (!ownerRead || !ownerWrite || !ownerExecute || groupRead || groupWrite || groupExecute || othersRead || othersWrite || othersExecute) {
                throw new IllegalStateException("Wrong permissions for file " + this.masterPasswordFile.getAbsolutePath() + ", it should be 700");
            }
            String owner = fileView.readAttributes().owner().getName();
            String group = fileView.readAttributes().group().getName();
            String permStr = PosixFilePermissions.toString(filePermissions);
            this.LOG.log(Level.INFO, "Passed permissions check for file " + this.masterPasswordFile.getAbsolutePath() + ". Owner: " + owner + " Group: " + group + " Permissions: " + permStr);
            this.initHazelcast();
            this.rand = new Random();
        }
        catch (UnsupportedOperationException ex) {
            this.LOG.log(Level.WARNING, "Associated filesystem is not POSIX compliant. Continue without checking the permissions of " + this.masterPasswordFile.getAbsolutePath() + " This might be a security problem.");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error while getting POSIX permissions of " + this.masterPasswordFile.getAbsolutePath());
        }
    }

    @Lock(value=LockType.READ)
    public String getMasterEncryptionPassword() throws IOException {
        return this.certificateMasterPwdMgm.getMasterEncryptionPassword(this.masterPasswordFile);
    }

    @Lock(value=LockType.READ)
    public void checkPassword(String providedPassword, String userRequestedEmail) throws IOException, EncryptionMasterPasswordException {
        this.certificateMasterPwdMgm.checkPassword(providedPassword, userRequestedEmail, this.masterPasswordFile, this.userFacade);
    }

    @Lock(value=LockType.WRITE)
    public Integer initUpdateOperation() {
        Integer operationId = this.rand.nextInt();
        this.putUpdateStatusCache(operationId, UPDATE_STATUS.WORKING);
        return operationId;
    }

    @Lock(value=LockType.READ)
    public UPDATE_STATUS getOperationStatus(Integer operationId) {
        UPDATE_STATUS status = this.getIfPresentUpdateStatusCache(operationId);
        return status != null ? status : UPDATE_STATUS.NOT_FOUND;
    }

    @Asynchronous
    @Lock(value=LockType.WRITE)
    public void resetMasterEncryptionPassword(Integer operationId, String newMasterPasswd, String userRequested) throws ExecutionException, InterruptedException {
        MasterPasswordResetResult resetResult;
        Future<MasterPasswordResetResult> futureResetResult = this.certificateMasterPwdMgm.resetMasterEncryptionPassword(newMasterPasswd, this.masterPasswordFile, this.handlers, this.handlersResult);
        try {
            resetResult = futureResetResult.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.sendUnsuccessfulMessage(e.getMessage(), userRequested);
            this.putUpdateStatusCache(operationId, UPDATE_STATUS.FAILED);
            throw e;
        }
        if (UPDATE_STATUS.OK.equals((Object)resetResult.getUpdateStatus())) {
            this.sendSuccessfulMessage(resetResult.getSuccessLog(), userRequested);
            this.putUpdateStatusCache(operationId, UPDATE_STATUS.OK);
            if (this.masterPasswordUpdatedTopic != null) {
                this.masterPasswordUpdatedTopic.publish((Object)DigestUtils.sha256Hex((String)newMasterPasswd));
            }
        } else {
            this.sendUnsuccessfulMessage(resetResult.getErrorLog(), userRequested);
            this.putUpdateStatusCache(operationId, UPDATE_STATUS.FAILED);
        }
    }

    @Lock(value=LockType.WRITE)
    public void updateMasterEncryptionPassword(String newPassword) throws IOException {
        FileUtils.writeStringToFile((File)this.masterPasswordFile, (String)newPassword, (Charset)Charset.defaultCharset());
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void issueServiceKeyRotationCommand() {
        List allHosts = this.hostsFacade.findAll();
        for (Hosts host : allHosts) {
            SystemCommand rotateCommand = new SystemCommand(host, Operation.SERVICE_KEY_ROTATION);
            this.systemCommandFacade.persist(rotateCommand);
        }
    }

    private void sendSuccessfulMessage(String successLog, String userRequested) {
        this.sendInbox(successLog, "Changed successfully", userRequested);
    }

    private void sendUnsuccessfulMessage(String message, String userRequested) {
        this.sendInbox(message, "Change failed!", userRequested);
    }

    private void sendInbox(String message, String preview, String userRequested) {
        Users to = this.userFacade.findByEmail(userRequested);
        Users from = this.userFacade.findByEmail(this.settings.getAdminEmail());
        this.messageController.send(to, from, "Master encryption password changed", preview, message, "");
    }

    public static enum UPDATE_STATUS {
        OK,
        WORKING,
        FAILED,
        NOT_FOUND;

    }
}

