/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.upload;

import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.upload.FlowInfo;
import io.hops.hopsworks.common.upload.ResumableInfoStorage;
import io.hops.hopsworks.common.upload.StagingManager;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.AccessControlException;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class UploadController {
    private static final Logger LOGGER = Logger.getLogger(UploadController.class.getName());
    @EJB
    private StagingManager stagingManager;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private ResumableInfoStorage storage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPermission(FlowInfo flowInfo, String path, String username) throws IOException, DatasetException {
        if (username != null) {
            DistributedFileSystemOps udfso = null;
            try {
                udfso = this.dfs.getDfsOps(username);
                this.checkPermission(udfso, flowInfo, path);
            }
            finally {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    public boolean upload(InputStream uploadedInputStream, FlowInfo flowInfo, String hdfsPath, String username) throws DatasetException, AccessControlException {
        LOGGER.log(Level.FINE, "Uploading:- chunk: {0}, id: {1}", new Object[]{flowInfo.getChunkNumber(), flowInfo.getIdentifier()});
        try {
            return this.hdfsStagingUpload(uploadedInputStream, flowInfo, hdfsPath, username);
        }
        catch (AccessControlException ex) {
            throw new AccessControlException("Permission denied: You can not upload to this folder. ");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to upload file: {0}", flowInfo.getFilename());
            throw new DatasetException(RESTCodes.DatasetErrorCode.UPLOAD_ERROR, Level.FINE, "Failed to upload." + e.getMessage(), e.getMessage());
        }
    }

    public boolean isUploaded(FlowInfo flowInfo, String hdfsPath) {
        flowInfo.setFilePath(this.getTmpStagingDir(flowInfo.getFilename(), hdfsPath).toString());
        return this.storage.isUploaded(flowInfo.hashCode(), flowInfo.getChunkNumber());
    }

    private void checkPermission(DistributedFileSystemOps udfso, FlowInfo flowInfo, String path) throws IOException, DatasetException {
        String fileName = flowInfo.getFilename();
        Path dest = new Path(path, fileName);
        if (flowInfo.getChunkNumber() == 1) {
            try {
                if (udfso.exists(dest)) {
                    throw new DatasetException(RESTCodes.DatasetErrorCode.DESTINATION_EXISTS, Level.FINE, "Destination already exists. path: " + dest);
                }
                udfso.touchz(dest);
                udfso.rm(dest, false);
            }
            catch (AccessControlException ex) {
                throw new AccessControlException("Permission denied: You can not upload to this folder. ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveChunk(DistributedFileSystemOps dfsOps, InputStream uploadedInputStream, FlowInfo info, int chunkNumber) throws IOException {
        Path location = new Path(info.getFilePath(), String.valueOf(chunkNumber));
        FSDataOutputStream out = null;
        try {
            out = dfsOps.create(location);
            IOUtils.copy((InputStream)uploadedInputStream, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)uploadedInputStream);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean markAsUploadedAndCheckFinished(DistributedFileSystemOps dfsOps, FlowInfo info, int chunkNumber, long contentLength) throws IOException {
        block8: {
            block7: {
                FileStatus[] fileStatuses;
                if (!this.storage.addChunkAndCheckIfFinished(info, chunkNumber, contentLength)) break block8;
                Path location = new Path(info.getFilePath());
                if (!dfsOps.exists(location) || !dfsOps.getFileStatus(location).isDirectory() || (fileStatuses = dfsOps.listStatus(location)) == null || fileStatuses.length <= 0) break block7;
                if (fileStatuses.length > 1) {
                    Arrays.sort(fileStatuses, Comparator.comparingInt(o -> Integer.parseInt(o.getPath().getName())));
                }
                Path collected = this.fromTemp(location);
                FSDataOutputStream out = null;
                FSDataInputStream in = null;
                try {
                    out = dfsOps.create(collected);
                    for (FileStatus fileStatus : fileStatuses) {
                        try {
                            in = dfsOps.open(fileStatus.getPath());
                            IOUtils.copy((InputStream)in, (OutputStream)out);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(in);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)in);
                    }
                    dfsOps.rm(location, true);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)out);
                }
            }
            return true;
        }
        return false;
    }

    private void copyToHdfs(DistributedFileSystemOps dfsOps, FlowInfo info, String hdfsPath) throws IOException {
        try {
            Path location = new Path(hdfsPath, info.getFilename());
            Path stagingFilePath = this.fromTemp(info.getFilePath());
            if (!stagingFilePath.equals((Object)location)) {
                dfsOps.moveWithinHdfs(stagingFilePath, location, true);
                LOGGER.log(Level.INFO, "Move within Hdfs. {0}", new Object[]{stagingFilePath, location});
            }
            dfsOps.setPermission(location, dfsOps.getParentPermission(location));
            LOGGER.log(Level.INFO, "Copied to HDFS. {0}", location);
        }
        catch (AccessControlException ex) {
            throw new AccessControlException("Permission denied: You can not upload to this folder. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hdfsStagingUpload(InputStream uploadedInputStream, FlowInfo flowInfo, String hdfsPath, String username) throws DatasetException, IOException {
        boolean finished;
        DistributedFileSystemOps dfsOps = null;
        try {
            dfsOps = this.dfs.getDfsOps(username);
            this.checkPermission(dfsOps, flowInfo, hdfsPath);
            String resumableFilePath = this.getTmpStagingDir(dfsOps, flowInfo.getFilename(), hdfsPath);
            flowInfo.setFilePath(resumableFilePath);
            this.storage.put(flowInfo);
            this.saveChunk(dfsOps, uploadedInputStream, flowInfo, flowInfo.getChunkNumber());
            finished = this.markAsUploadedAndCheckFinished(dfsOps, flowInfo, flowInfo.getChunkNumber(), flowInfo.getCurrentChunkSize());
            if (finished) {
                this.copyToHdfs(dfsOps, flowInfo, hdfsPath);
            }
        }
        finally {
            if (dfsOps != null) {
                this.dfs.closeDfsClient(dfsOps);
            }
        }
        return finished;
    }

    private String getTmpStagingDir(DistributedFileSystemOps dfsOps, String filename, String hdfsPath) throws DatasetException {
        Path userTmpDir = this.getTmpStagingDir(filename, hdfsPath);
        try {
            boolean created;
            if (!dfsOps.exists(userTmpDir) && !(created = dfsOps.mkdirs(userTmpDir, dfsOps.getParentPermission(userTmpDir)))) {
                LOGGER.log(Level.WARNING, "Failed to create upload staging dir. Path: {0}", userTmpDir.toString());
            }
            return userTmpDir.toString();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to create upload staging dir. Path: {0}", userTmpDir.toString());
            throw new DatasetException(RESTCodes.DatasetErrorCode.UPLOAD_ERROR, Level.SEVERE, "Failed to create upload staging dir", e.getMessage(), (Throwable)e);
        }
    }

    private Path getTmpStagingDir(String filename, String hdfsPath) {
        String baseDir = this.stagingManager.getStagingPath() + hdfsPath;
        return this.toTemp(baseDir, filename);
    }

    private Path toTemp(String baseDir, String filename) {
        return new Path(baseDir, filename + ".temp");
    }

    private Path fromTemp(Path path) {
        return this.fromTemp(path.toString().replace(".temp", ""));
    }

    private Path fromTemp(String path) {
        return new Path(path.replace(".temp", ""));
    }
}

