/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.featurestore.metadata;

import io.hops.hopsworks.common.dao.featurestore.metadata.FeatureStoreMetadataFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.metadata.FeatureStoreKeyword;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.TypedQuery;

@Stateless
public class FeatureStoreKeywordFacade
extends FeatureStoreMetadataFacade<FeatureStoreKeyword> {
    public static final String NAME = "name";

    public FeatureStoreKeywordFacade() {
        super(FeatureStoreKeyword.class);
    }

    @Override
    protected String getTableName() {
        return "FeatureStoreKeyword";
    }

    public int removeByName(Featuregroup fg, String keyword) {
        HashSet<String> keywords = new HashSet<String>();
        keywords.add(keyword);
        return this.removeByName("featureGroup", fg, keywords);
    }

    public int removeByName(FeatureView fv, String keyword) {
        HashSet<String> keywords = new HashSet<String>();
        keywords.add(keyword);
        return this.removeByName("featureView", fv, keywords);
    }

    public int removeByName(TrainingDataset td, String keyword) {
        HashSet<String> keywords = new HashSet<String>();
        keywords.add(keyword);
        return this.removeByName("trainingDataset", td, keywords);
    }

    public int removeByName(Featuregroup fg, Set<String> keywords) {
        return this.removeByName("featureGroup", fg, keywords);
    }

    public int removeByName(FeatureView fv, Set<String> keywords) {
        return this.removeByName("featureView", fv, keywords);
    }

    public int removeByName(TrainingDataset td, Set<String> keywords) {
        return this.removeByName("trainingDataset", td, keywords);
    }

    private int removeByName(String artifactType, Object artifact, Set<String> keywords) {
        String queryStr = "DELETE FROM " + this.getTableName() + " m ";
        queryStr = queryStr + " WHERE m." + artifactType + " = :" + artifactType;
        queryStr = queryStr + " AND m.name IN :name";
        TypedQuery query = this.em.createQuery(queryStr, this.entityClass);
        query.setParameter(artifactType, artifact);
        query.setParameter(NAME, keywords);
        return query.executeUpdate();
    }

    public List<String> getAll() {
        String queryStr = "SELECT DISTINCT m.name FROM " + this.getTableName() + " m";
        TypedQuery query = this.em.createQuery(queryStr, String.class);
        return query.getResultList();
    }
}

