/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.hdfs.inode;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsersFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.persistence.InvalidQueryException;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.hdfs.inode.InodePK;
import io.hops.hopsworks.persistence.entity.hdfs.user.HdfsUsers;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class InodeFacade
extends AbstractFacade<Inode> {
    private static final Logger LOGGER = Logger.getLogger(InodeFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    @EJB
    private HdfsUsersFacade hdfsUsersFacade;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private UserFacade userFacade;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public InodeFacade() {
        super(Inode.class);
    }

    public List<Inode> findByParent(Inode parent) {
        TypedQuery query = this.em.createNamedQuery("Inode.findByParentId", Inode.class);
        query.setParameter("parentId", (Object)parent.getId());
        return query.getResultList();
    }

    public Long countByParentId(Inode parent) {
        TypedQuery query = this.em.createNamedQuery("Inode.countByParentId", Long.class);
        query.setParameter("parentId", (Object)parent.getId());
        return (Long)query.getSingleResult();
    }

    public List<Inode> findByHdfsUser(HdfsUsers hdfsUser) {
        TypedQuery query = this.em.createNamedQuery("Inode.findByHdfsUser", Inode.class);
        query.setParameter("hdfsUser", (Object)hdfsUser);
        return query.getResultList();
    }

    public Inode findParent(Inode i) {
        if (i == null) {
            throw new IllegalArgumentException("Inode must be provided.");
        }
        long id = i.getInodePK().getParentId();
        TypedQuery q = this.em.createNamedQuery("Inode.findById", Inode.class);
        q.setParameter("id", (Object)id);
        try {
            return (Inode)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Inode findById(Long id) {
        TypedQuery q = this.em.createNamedQuery("Inode.findById", Inode.class);
        q.setParameter("id", (Object)id);
        try {
            return (Inode)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<Inode> findByIdList(List<Long> ids) {
        TypedQuery q = this.em.createNamedQuery("Inode.findByIdInList", Inode.class);
        q.setParameter("idList", ids);
        return q.getResultList();
    }

    public Inode getRootNode(String name) {
        long partitionId = HopsUtils.calculatePartitionId(HopsUtils.ROOT_INODE_ID, name, 1);
        TypedQuery query = this.em.createNamedQuery("Inode.findRootByName", Inode.class);
        query.setParameter("name", (Object)name);
        query.setParameter("parentId", (Object)HopsUtils.ROOT_INODE_ID);
        query.setParameter("partitionId", (Object)partitionId);
        try {
            return (Inode)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOGGER.log(Level.WARNING, "Could not resolve root inode with name: {0} and partition_id" + partitionId, name);
            return null;
        }
    }

    public Inode findByInodePK(Inode parent, String name, long partitionId) {
        TypedQuery q = this.em.createNamedQuery("Inode.findByPrimaryKey", Inode.class);
        q.setParameter("inodePk", (Object)new InodePK(parent.getId().longValue(), name, partitionId));
        try {
            return (Inode)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Inode findByParentAndName(Inode parent, String name) {
        TypedQuery q = this.em.createNamedQuery("Inode.findByParentAndName", Inode.class);
        q.setParameter("parentId", (Object)parent.getId()).setParameter("name", (Object)name);
        try {
            return (Inode)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<Inode> findHistoryFileByHdfsUser(HdfsUsers hdfsUser) {
        TypedQuery query = this.em.createNamedQuery("Inode.findHistoryFileByHdfsUser", Inode.class);
        query.setParameter("hdfsUser", (Object)hdfsUser);
        return query.getResultList();
    }

    public AbstractFacade.CollectionInfo findByParentAndPartition(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort, Inode parent, Long partitionId, Project project) {
        String queryStr = this.buildQuery("SELECT i FROM Inode i ", filter, sort, "i.inodePK.partitionId = :partitionId AND i.inodePK.parentId = :parentId ");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT i.inodePK.name) FROM Inode i ", filter, null, "i.inodePK.partitionId = :partitionId AND i.inodePK.parentId = :parentId ");
        Long parentId = parent != null ? parent.getId() : null;
        TypedQuery query = this.em.createQuery(queryStr, Inode.class).setParameter("parentId", (Object)parentId).setParameter("partitionId", (Object)partitionId);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, Inode.class).setParameter("parentId", (Object)parentId).setParameter("partitionId", (Object)partitionId);
        return this.getResult(offset, limit, filter, project, (Query)query, (Query)queryCount);
    }

    public AbstractFacade.CollectionInfo findByParent(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort, Inode parent, Project project) {
        String queryStr = this.buildQuery("SELECT i FROM Inode i ", filter, sort, "i.inodePK.parentId = :parentId ");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT i.inodePK.name) FROM Inode i ", filter, null, "i.inodePK.parentId = :parentId ");
        Long parentId = parent != null ? parent.getId() : null;
        TypedQuery query = this.em.createQuery(queryStr, Inode.class).setParameter("parentId", (Object)parentId);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, Inode.class).setParameter("parentId", (Object)parentId);
        return this.getResult(offset, limit, filter, project, (Query)query, (Query)queryCount);
    }

    private AbstractFacade.CollectionInfo getResult(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Project project, Query query, Query queryCount) {
        this.setFilter(filter, query, project);
        this.setFilter(filter, queryCount, project);
        this.setOffsetAndLim(offset, limit, query);
        AbstractFacade.CollectionInfo collectionInfo = new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
        return collectionInfo;
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q, Project project) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q, project);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q, Project project) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case NAME: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam());
                break;
            }
            case UNDER_CONSTRUCTION: {
                q.setParameter(filterBy.getField(), (Object)this.getBooleanValue(filterBy.getParam()));
                break;
            }
            case HDFS_USER: {
                q.setParameter(filterBy.getField(), (Object)this.gethdfsUser(filterBy.getParam()));
                break;
            }
            case USER_EMAIL: {
                q.setParameter(filterBy.getField(), (Object)this.getUsers(filterBy.getParam(), project));
                break;
            }
            case ACCESS_TIME: 
            case ACCESS_TIME_GT: 
            case ACCESS_TIME_LT: 
            case MODIFICATION_TIME: 
            case MODIFICATION_TIME_GT: 
            case MODIFICATION_TIME_LT: {
                Date date = this.getDate(filterBy.getField(), filterBy.getParam());
                q.setParameter(filterBy.getField(), (Object)date.getTime());
                break;
            }
            case SIZE: 
            case SIZE_LT: 
            case SIZE_GT: {
                q.setParameter(filterBy.getField(), (Object)this.getIntValue(filterBy));
                break;
            }
        }
    }

    public HdfsUsers gethdfsUser(String value) {
        HdfsUsers hdfsUser = this.hdfsUsersFacade.findByName(value);
        return hdfsUser;
    }

    public HdfsUsers getUsers(String email, Project project) {
        Users user = this.userFacade.findByEmail(email);
        if (project == null) {
            throw new InvalidQueryException("Filter by email needs a project.");
        }
        if (user != null) {
            String hdfsUserName = this.hdfsUsersController.getHdfsUserName(project, user);
            return this.hdfsUsersFacade.findByName(hdfsUserName);
        }
        return null;
    }

    public static enum Filters {
        NAME("NAME", "i.inodePK.name LIKE CONCAT(:name, '%') ", "name", " "),
        USER_EMAIL("USER_EMAIL", "i.hdfsUser =:user ", "user", " "),
        HDFS_USER("HDFS_USER", "i.hdfsUser =:hdfsUser ", "hdfsUser", " "),
        UNDER_CONSTRUCTION("UNDER_CONSTRUCTION", "i.underConstruction  =:underConstruction ", "underConstruction", "true"),
        MODIFICATION_TIME("MODIFICATION_TIME", "i.modificationTime  =:modificationTime ", "modificationTime", ""),
        MODIFICATION_TIME_LT("MODIFICATION_TIME_LT", "i.modificationTime  <:modificationTime_lt ", "modificationTime_lt", ""),
        MODIFICATION_TIME_GT("MODIFICATION_TIME_GT", "i.modificationTime  >:modificationTime_gt ", "modificationTime_gt", ""),
        ACCESS_TIME("ACCESS_TIME", "i.accessTime  =:accessTime ", "accessTime", ""),
        ACCESS_TIME_LT("ACCESS_TIME_LT", "i.accessTime  <:accessTime_lt ", "accessTime_lt", ""),
        ACCESS_TIME_GT("ACCESS_TIME_GT", "i.accessTime  >:accessTime_gt ", "accessTime_gt", ""),
        SIZE("SIZE", "i.size  =:size_eq ", "size_eq", "0"),
        SIZE_LT("SIZE_LT", "i.size  <:size_lt ", "size_lt", "1"),
        SIZE_GT("SIZE_GT", "i.size  >:size_gt ", "size_gt", "0");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", "i.id ", "ASC"),
        NAME("NAME", "LOWER(i.inodePK.name) ", "ASC"),
        MODIFICATION_TIME("MODIFICATION_TIME", "i.modificationTime ", "ASC"),
        ACCESS_TIME("ACCESS_TIME", "i.accessTime ", "ASC"),
        SIZE("SIZE", "i.size ", "ASC"),
        TYPE("TYPE", "i.dir ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

