/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jobhistory;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.InvalidQueryException;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobType;
import io.hops.hopsworks.persistence.entity.jobs.configuration.history.JobFinalStatus;
import io.hops.hopsworks.persistence.entity.jobs.configuration.history.JobState;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import io.hops.hopsworks.persistence.entity.jobs.history.Execution;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.javatuples.Pair;

@Stateless
public class ExecutionFacade
extends AbstractFacade<Execution> {
    private static final Logger logger = Logger.getLogger(ExecutionFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public ExecutionFacade() {
        super(Execution.class);
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public Optional<Execution> findByAppId(String appId) {
        try {
            return Optional.of(this.em.createNamedQuery("Execution.findByAppId", Execution.class).setParameter("appId", (Object)appId).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<Execution> findById(int id) {
        try {
            return Optional.of(this.em.createNamedQuery("Execution.findById", Execution.class).setParameter("id", (Object)id).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public List<Execution> findByProjectAndType(Project project, JobType type) {
        TypedQuery q = this.em.createNamedQuery("Execution.findByProjectAndType", Execution.class);
        q.setParameter("type", (Object)type);
        q.setParameter("project", (Object)project);
        return q.getResultList();
    }

    public List<Execution> findByProjectAndNotFinished(Project project) {
        return this.findByProjectAndStatesQuery(project, JobState.getRunningStates()).getResultList();
    }

    private TypedQuery<Execution> findByProjectAndStatesQuery(Project project, Set<JobState> states) {
        return this.em.createNamedQuery("Execution.findByProjectAndStates", Execution.class).setParameter("project", (Object)project).setParameter("states", states);
    }

    public List<Execution> findByJob(Jobs job) {
        TypedQuery q = this.em.createNamedQuery("Execution.findByJob", Execution.class);
        q.setParameter("job", (Object)job);
        return q.getResultList();
    }

    public List<Execution> findOrphaned(Pair<Integer, Integer> range) {
        TypedQuery q = this.em.createNamedQuery("Execution.findOrphanExecutions", Execution.class);
        if (range != null) {
            q.setMaxResults((Integer)range.getValue1() - (Integer)range.getValue0());
            q.setFirstResult(((Integer)range.getValue0()).intValue());
        } else {
            q.setFirstResult(0);
            q.setMaxResults(Integer.MAX_VALUE);
        }
        return q.getResultList();
    }

    public List<Execution> findByJobAndNotFinished(Jobs job) {
        TypedQuery q = this.em.createNamedQuery("Execution.findByJobAndStates", Execution.class);
        q.setParameter("job", (Object)job);
        q.setParameter("states", (Object)JobState.getRunningStates());
        return q.getResultList();
    }

    public List<Execution> findNotFinished() {
        return this.em.createNamedQuery("Execution.findByStates", Execution.class).setParameter("states", (Object)JobState.getRunningStates()).getResultList();
    }

    public List<Execution> findByTypesAndStates(Set<JobType> types, Set<JobState> jobStates) {
        TypedQuery q = this.em.createNamedQuery("Execution.findByTypesAndStates", Execution.class);
        q.setParameter("types", types);
        q.setParameter("states", jobStates);
        return q.getResultList();
    }

    public AbstractFacade.CollectionInfo findByJob(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filters, Set<? extends AbstractFacade.SortBy> sorts, Jobs job) {
        String duration = "";
        String queryStr = this.buildQuery("SELECT e" + duration + " FROM Execution e ", filters, sorts, "e.job = :job ");
        String queryCountStr = this.buildQuery("SELECT COUNT(e.id) FROM Execution e ", filters, sorts, "e.job = :job ");
        TypedQuery query = this.em.createQuery(queryStr, Execution.class).setParameter("job", (Object)job);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, Execution.class).setParameter("job", (Object)job);
        this.setFilter(filters, (Query)query);
        this.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public int batchDelete(List<Execution> executions) {
        List executionIds = executions.stream().map(Execution::getId).collect(Collectors.toList());
        logger.log(Level.FINE, "Delete executionIds:" + executionIds);
        TypedQuery query = this.em.createNamedQuery("Execution.deleteBatch", Execution.class);
        query.setParameter("executionIds", executionIds);
        return query.executeUpdate();
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case STATE: 
            case STATE_NEQ: {
                HashSet<JobState> jobTypes = new HashSet<JobState>(this.getJobStates(filterBy.getField(), filterBy.getParam()));
                q.setParameter(filterBy.getField(), jobTypes);
                break;
            }
            case SUBMISSIONTIME_GT: 
            case SUBMISSIONTIME_LT: 
            case SUBMISSIONTIME: {
                Date date = this.getDate(filterBy.getField(), filterBy.getParam());
                q.setParameter(filterBy.getField(), (Object)date);
                break;
            }
            case FINALSTATUS: 
            case FINALSTATUS_NEQ: {
                HashSet<JobFinalStatus> jobFinalStatuses = new HashSet<JobFinalStatus>(this.getJobFinalStatus(filterBy.getField(), filterBy.getParam()));
                q.setParameter(filterBy.getField(), jobFinalStatuses);
                break;
            }
        }
    }

    private Set<JobState> getJobStates(String field, String values) {
        HashSet<JobState> states = new HashSet<JobState>();
        for (String state : values.split(",")) {
            states.add(JobState.valueOf((String)state.trim()));
        }
        return states;
    }

    private Set<JobFinalStatus> getJobFinalStatus(String field, String values) {
        HashSet<JobFinalStatus> statuses = new HashSet<JobFinalStatus>();
        for (String status : values.split(",")) {
            try {
                statuses.add(JobFinalStatus.valueOf((String)status.trim()));
            }
            catch (IllegalArgumentException ie) {
                throw new InvalidQueryException("Filter value for " + field + " needs to set a valid " + field + ", but found: " + status);
            }
        }
        if (statuses.isEmpty()) {
            throw new InvalidQueryException("Filter value for " + field + " needs to set valid execution statuses, but found: " + values);
        }
        return statuses;
    }

    public Execution create(Jobs job, Users user, String stdoutPath, String stderrPath, JobFinalStatus finalStatus, float progress, String hdfsUser, String args) {
        return this.create(job, user, JobState.INITIALIZING, stdoutPath, stderrPath, finalStatus, progress, hdfsUser, args);
    }

    public Execution create(Jobs job, Users user, JobState state, String stdoutPath, String stderrPath, JobFinalStatus finalStatus, float progress, String hdfsUser, String args) {
        if (state == null) {
            state = JobState.INITIALIZING;
        }
        if (finalStatus == null) {
            finalStatus = JobFinalStatus.UNDEFINED;
        }
        Execution exec = new Execution(state, job, user, new Date(), stdoutPath, stderrPath, finalStatus, progress, hdfsUser, args);
        this.em.persist((Object)exec);
        this.em.flush();
        return exec;
    }

    public Execution updateState(Execution exec, JobState newState) {
        exec = this.getExecution(exec);
        exec.setState(newState);
        this.merge(exec);
        return exec;
    }

    public Execution updateFinalStatus(Execution exec, JobFinalStatus finalStatus) {
        exec = this.getExecution(exec);
        exec.setFinalStatus(finalStatus);
        this.merge(exec);
        return exec;
    }

    public Execution updateProgress(Execution exec, float progress) {
        exec = this.getExecution(exec);
        exec.setProgress(progress);
        this.merge(exec);
        return exec;
    }

    public Execution updateExecutionStart(Execution exec, long executionStart) {
        exec = this.getExecution(exec);
        exec.setExecutionStart(executionStart);
        this.merge(exec);
        return exec;
    }

    public Execution updateExecutionStop(Execution exec, long executionStop) {
        exec = this.getExecution(exec);
        exec.setExecutionStop(executionStop);
        this.merge(exec);
        return exec;
    }

    public Execution updateOutput(Execution exec) {
        exec = this.getExecution(exec);
        this.merge(exec);
        return exec;
    }

    public Execution updateStdOutPath(Execution exec, String stdOutPath) {
        exec = this.getExecution(exec);
        exec.setStdoutPath(stdOutPath);
        this.merge(exec);
        return exec;
    }

    public Execution updateStdErrPath(Execution exec, String stdErrPath) {
        exec = this.getExecution(exec);
        exec.setStderrPath(stdErrPath);
        this.merge(exec);
        return exec;
    }

    public Execution updateAppId(Execution exec, String appId) {
        exec = this.getExecution(exec);
        exec.setAppId(appId);
        this.merge(exec);
        return exec;
    }

    public Execution updateFilesToRemove(Execution exec, List<String> filesToRemove) {
        exec = this.getExecution(exec);
        exec.setFilesToRemove(filesToRemove);
        this.merge(exec);
        return exec;
    }

    private Execution getExecution(Execution exec) {
        Execution obj = (Execution)this.em.find(Execution.class, (Object)exec.getId());
        for (int count = 0; obj == null && count < 10; ++count) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            logger.info("Trying to get the Execution Object");
            obj = (Execution)this.em.find(Execution.class, (Object)exec.getId());
        }
        if (obj == null) {
            throw new IllegalStateException("Unable to find Execution object with id " + exec.getId());
        }
        return obj;
    }

    private void merge(Execution exec) {
        this.em.merge((Object)exec);
    }

    public static enum Filters {
        STATE("STATE", "e.state IN :states ", "states", ""),
        STATE_NEQ("STATE_NEQ", "e.state NOT IN :states_neq ", "states_neq", ""),
        FINALSTATUS("FINALSTATUS", "e.finalStatus IN :finalstatuses ", "finalstatuses", ""),
        FINALSTATUS_NEQ("FINALSTATUS_NEQ", "e.finalStatus NOT IN :finalstatuses ", "finalstatuses", ""),
        SUBMISSIONTIME("SUBMISSIONTIME", "e.submissionTime = :submissionTime ", "submissionTime", ""),
        SUBMISSIONTIME_LT("SUBMISSIONTIME_LT", "e.submissionTime < :submissionTimeTo ", "submissionTimeTo", ""),
        SUBMISSIONTIME_GT("SUBMISSIONTIME_GT", "e.submissionTime > :submissionTimeFrom ", "submissionTimeFrom", "");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", "e.id ", "ASC"),
        SUBMISSIONTIME("SUBMISSIONTIME", "e.submissionTime ", "DESC"),
        USER("CREATOR", "LOWER(CONCAT (e.user.fname, e.user.lname)) ", "ASC"),
        USER_FIRST_NAME("USER_FIRSTNAME", "e.user.fname ", "ASC"),
        USER_LAST_NAME("USER_LASTNAME", "e.user.lname ", "ASC"),
        STATE("STATE", "e.state ", "ASC"),
        FINALSTATUS("FINALSTATUS", "e.finalStatus ", "ASC"),
        APPID("APPID", "e.appId ", "DESC"),
        PROGRESS("PROGRESS", "e.progress ", "ASC"),
        DURATION("DURATION", "e.executionStop-e.executionStart ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

