/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jupyter;

import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.jobs.configuration.ExperimentType;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.configuration.spark.SparkJobConfiguration;
import io.hops.hopsworks.persistence.entity.jupyter.JupyterSettings;
import io.hops.hopsworks.persistence.entity.jupyter.JupyterSettingsPK;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.commons.codec.digest.DigestUtils;

@Stateless
public class JupyterSettingsFacade {
    @EJB
    private ProjectUtils projectUtils;
    private static final Logger logger = Logger.getLogger(JupyterSettingsFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public List<JupyterSettings> findJupyterSettingsByProject(Integer projectId) {
        TypedQuery query = this.em.createNamedQuery("JupyterSettings.findByProjectId", JupyterSettings.class);
        query.setParameter("projectId", (Object)projectId);
        return query.getResultList();
    }

    public JupyterSettings findByProjectUser(Project project, String email) {
        JupyterSettingsPK pk = new JupyterSettingsPK(project.getId().intValue(), email);
        JupyterSettings js = (JupyterSettings)this.em.find(JupyterSettings.class, (Object)pk);
        if (js == null) {
            String secret = DigestUtils.sha256Hex((String)Integer.toString(ThreadLocalRandom.current().nextInt()));
            js = new JupyterSettings(pk);
            js.setSecret(secret);
            js.setJobConfig((JobConfiguration)new SparkJobConfiguration(ExperimentType.EXPERIMENT));
            js.setDockerConfig((JobConfiguration)this.projectUtils.buildDockerJobConfiguration());
            js.setBaseDir(Utils.getProjectPath(project.getName()) + Settings.ServiceDataset.JUPYTER.getName());
            this.persist(js);
        }
        if (js.getJobConfig() == null) {
            js.setJobConfig((JobConfiguration)new SparkJobConfiguration(ExperimentType.EXPERIMENT));
        }
        if (js.getDockerConfig() == null) {
            js.setDockerConfig((JobConfiguration)this.projectUtils.buildDockerJobConfiguration());
        }
        return js;
    }

    private void persist(JupyterSettings js) {
        if (js != null) {
            this.em.persist((Object)js);
        }
    }

    public void update(JupyterSettings js) {
        if (js != null) {
            this.em.merge((Object)js);
        }
    }

    private void remove(JupyterSettings js) {
        if (js != null) {
            this.em.remove((Object)js);
        }
    }
}

