/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.query.join;

import io.hops.hopsworks.common.featurestore.query.ConstructorController;
import io.hops.hopsworks.common.featurestore.query.Feature;
import io.hops.hopsworks.common.featurestore.query.Query;
import io.hops.hopsworks.common.featurestore.query.join.Join;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.SqlCondition;
import java.util.Arrays;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class JoinController {
    @EJB
    private ConstructorController constructorController;

    public JoinController() {
    }

    public JoinController(ConstructorController constructorController) {
        this.constructorController = constructorController;
    }

    public SqlNode buildJoinNode(Query query, int i, boolean online) {
        if (i < 0) {
            return this.constructorController.generateTableNode(query, online);
        }
        return new SqlJoin(SqlParserPos.ZERO, this.buildJoinNode(query, i - 1, online), SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), SqlLiteral.createSymbol((Enum)query.getJoins().get(i).getJoinType(), (SqlParserPos)SqlParserPos.ZERO), this.constructorController.generateTableNode(query.getJoins().get(i).getRightQuery(), online), SqlLiteral.createSymbol((Enum)JoinConditionType.ON, (SqlParserPos)SqlParserPos.ZERO), this.getLeftRightCondition(query.getJoins().get(i), online));
    }

    public SqlNode getLeftRightCondition(Join join, boolean online) {
        return this.getLeftRightCondition(join.getLeftQuery().getAs(), join.getRightQuery().getAs(), join.getLeftOn(), join.getRightOn(), join.getJoinOperator(), online);
    }

    public SqlNode getLeftRightCondition(String leftAs, String rightAs, List<Feature> leftOn, List<Feature> rightOn, List<SqlCondition> joinOperator, boolean online) {
        if (leftOn.size() == 1) {
            return this.generateCondition(leftAs, rightAs, leftOn.get(0), rightOn.get(0), online, joinOperator.get(0));
        }
        SqlNodeList conditionList = new SqlNodeList(SqlParserPos.ZERO);
        for (int i = 0; i < leftOn.size(); ++i) {
            conditionList = this.compactEquality(conditionList);
            conditionList.add(this.generateCondition(leftAs, rightAs, leftOn.get(i), rightOn.get(i), online, joinOperator.get(i)));
        }
        return SqlStdOperatorTable.AND.createCall(conditionList);
    }

    private SqlNodeList compactEquality(SqlNodeList conditionList) {
        if (conditionList.size() < 2) {
            return conditionList;
        }
        SqlNodeList compactedList = new SqlNodeList(SqlParserPos.ZERO);
        compactedList.add((SqlNode)SqlStdOperatorTable.AND.createCall(conditionList));
        return compactedList;
    }

    private SqlNode generateCondition(String leftFgAs, String rightFgAs, Feature leftOn, Feature rightOn, boolean online, SqlCondition sqlBinaryOperator) {
        Object leftHandside = leftOn.getDefaultValue() == null ? new SqlIdentifier(Arrays.asList("`" + leftFgAs + "`", "`" + leftOn.getName() + "`"), SqlParserPos.ZERO) : this.constructorController.caseWhenDefault(leftOn);
        Object rightHandside = rightOn.getDefaultValue() == null ? new SqlIdentifier(Arrays.asList("`" + rightFgAs + "`", "`" + rightOn.getName() + "`"), SqlParserPos.ZERO) : this.constructorController.caseWhenDefault(rightOn);
        SqlNodeList equalityList = new SqlNodeList(SqlParserPos.ZERO);
        equalityList.add(leftHandside);
        equalityList.add(rightHandside);
        return sqlBinaryOperator.operator.createCall(equalityList);
    }
}

