/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.updates.analyzer;

import io.hops.hopsworks.common.python.library.LibraryVersionDTO;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public abstract class LatestVersionAnalyzer {
    private final String releaseRegex = "^(\\d+[.]\\d+[.]\\d+)$";
    protected String latestVersion;

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public abstract String getLibrary();

    public abstract void setLatestVersion(String var1, HashMap<String, List<LibraryVersionDTO>> var2);

    public List<LibraryVersionDTO> filterReleases(List<LibraryVersionDTO> versions) {
        return versions.stream().filter(v -> v.getVersion().matches("^(\\d+[.]\\d+[.]\\d+)$")).collect(Collectors.toList());
    }

    protected class SortByVersionComparator
    implements Comparator<LibraryVersionDTO> {
        protected SortByVersionComparator() {
        }

        @Override
        public int compare(LibraryVersionDTO a, LibraryVersionDTO b) {
            Integer aMinorVersion = new Integer(a.getVersion().substring(a.getVersion().lastIndexOf(".") + 1));
            Integer bMinorVersion = new Integer(b.getVersion().substring(b.getVersion().lastIndexOf(".") + 1));
            return aMinorVersion.compareTo(bMinorVersion);
        }
    }
}

