/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jobs.description;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.jobs.scheduler.JobScheduleV2;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class JobScheduleV2Facade
extends AbstractFacade<JobScheduleV2> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public JobScheduleV2Facade() {
        super(JobScheduleV2.class);
    }

    public Optional<JobScheduleV2> getByJobId(Integer jobId) {
        TypedQuery query = this.em.createNamedQuery("JobSchedule.getByJobId", JobScheduleV2.class);
        query.setParameter("jobId", (Object)jobId);
        try {
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<JobScheduleV2> getById(Integer id) {
        TypedQuery query = this.em.createNamedQuery("JobSchedule.getById", JobScheduleV2.class);
        query.setParameter("id", (Object)id);
        try {
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public List<JobScheduleV2> getAll() {
        TypedQuery query = this.em.createNamedQuery("JobSchedule.getAll", JobScheduleV2.class);
        return query.getResultList();
    }

    public void removeByJobId(Integer jobId) {
        TypedQuery query = this.em.createNamedQuery("JobSchedule.getByJobId", JobScheduleV2.class);
        query.setParameter("jobId", (Object)jobId);
        for (JobScheduleV2 schedule : query.getResultList()) {
            this.remove(schedule);
        }
    }

    public List<JobScheduleV2> getActiveWithCurrentExecutionTime(Instant currentDateTime) {
        TypedQuery query = this.em.createNamedQuery("JobSchedule.getActiveWithCurrentExecutionTime", JobScheduleV2.class);
        query.setParameter("currentDateTime", (Object)Date.from(currentDateTime));
        return query.getResultList();
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }
}

