/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.python;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.CondaCommands;
import io.hops.hopsworks.persistence.entity.python.CondaInstallType;
import io.hops.hopsworks.persistence.entity.python.CondaOp;
import io.hops.hopsworks.persistence.entity.python.CondaStatus;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class CondaCommandFacade
extends AbstractFacade<CondaCommands> {
    private static final Logger LOGGER = Logger.getLogger(CondaCommandFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public void flushEm() {
        this.em.flush();
    }

    public CondaCommandFacade() {
        super(CondaCommands.class);
    }

    public int deleteAllCommandsByStatus(CondaStatus status) {
        TypedQuery query = this.em.createNamedQuery("CondaCommands.deleteAllFailedCommands", CondaCommands.class);
        query.setParameter("status", (Object)status);
        return query.executeUpdate();
    }

    public List<CondaCommands> getCommandsForProject(Project proj) {
        TypedQuery query = this.em.createNamedQuery("CondaCommands.findByProj", CondaCommands.class);
        query.setParameter("projectId", (Object)proj);
        return query.getResultList();
    }

    public List<CondaCommands> getFailedCommandsForProject(Project proj) {
        TypedQuery query = this.em.createNamedQuery("CondaCommands.findByProjectAndStatus", CondaCommands.class);
        query.setParameter("projectId", (Object)proj);
        query.setParameter("status", (Object)CondaStatus.FAILED);
        return query.getResultList();
    }

    public List<CondaCommands> getFailedEnvCommandsForProject(Project proj) {
        TypedQuery query = this.em.createNamedQuery("CondaCommands.findByProjectAndTypeAndStatus", CondaCommands.class);
        query.setParameter("projectId", (Object)proj);
        query.setParameter("installType", (Object)CondaInstallType.ENVIRONMENT);
        query.setParameter("status", (Object)CondaStatus.FAILED);
        return query.getResultList();
    }

    public List<CondaCommands> getFailedCommandsForProjectAndLib(Project proj, String lib) {
        TypedQuery query = this.em.createNamedQuery("CondaCommands.findByProjectAndLibAndStatus", CondaCommands.class);
        query.setParameter("projectId", (Object)proj);
        query.setParameter("lib", (Object)lib);
        query.setParameter("status", (Object)CondaStatus.FAILED);
        return query.getResultList();
    }

    public void deleteCommandsForLibrary(Project proj, String dependency) {
        List<CondaCommands> commands = this.getCommandsForProject(proj);
        for (CondaCommands cc : commands) {
            if (cc.getLib().compareToIgnoreCase(dependency) != 0) continue;
            this.em.remove((Object)cc);
        }
    }

    public void deleteCommandsForEnvironment(Project proj) {
        List<CondaCommands> commands = this.getCommandsForProject(proj);
        for (CondaCommands cc : commands) {
            if (!CondaOp.isEnvOp((CondaOp)cc.getOp()) || cc.getStatus().isRunning()) continue;
            this.em.remove((Object)cc);
        }
    }

    public void removeCondaCommand(int commandId) {
        CondaCommands cc = this.findCondaCommand(commandId);
        if (cc != null) {
            this.em.remove((Object)cc);
            this.em.flush();
        } else {
            LOGGER.log(Level.FINE, "Could not remove CondaCommand with id: {0}", commandId);
        }
    }

    public List<CondaCommands> findByStatus(CondaStatus status) {
        TypedQuery query = this.em.createNamedQuery("CondaCommands.findByStatus", CondaCommands.class);
        query.setParameter("status", (Object)status);
        return query.getResultList();
    }

    public List<CondaCommands> findByStatusAndCondaOp(CondaStatus status, CondaOp op) {
        TypedQuery query = this.em.createNamedQuery("CondaCommands.findByStatusAndCondaOp", CondaCommands.class);
        query.setParameter("status", (Object)status);
        query.setParameter("op", (Object)op);
        return query.getResultList();
    }

    public List<CondaCommands> findByStatusAndCondaOpAndProject(List<CondaStatus> statuses, CondaOp op, Project project) {
        TypedQuery query = this.em.createNamedQuery("CondaCommands.findByStatusListAndCondaOpAndProject", CondaCommands.class);
        query.setParameter("statuses", statuses);
        query.setParameter("op", (Object)op);
        query.setParameter("project", (Object)project);
        return query.getResultList();
    }

    public CondaCommands findCondaCommand(int commandId) {
        return (CondaCommands)this.em.find(CondaCommands.class, (Object)commandId);
    }

    public AbstractFacade.CollectionInfo findAllEnvCmdByProject(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort, Project project) {
        String queryStr = this.buildQuery("SELECT c FROM CondaCommands c ", filter, sort, "(c.installType = :environment OR c.installType = :customCommands) AND c.projectId = :project ");
        String queryCountStr = this.buildQuery("SELECT COUNT(c.id) FROM CondaCommands c ", filter, sort, "(c.installType = :environment OR c.installType = :customCommands) AND c.projectId = :project ");
        TypedQuery query = this.em.createQuery(queryStr, CondaCommands.class).setParameter("environment", (Object)CondaInstallType.ENVIRONMENT).setParameter("project", (Object)project).setParameter("customCommands", (Object)CondaInstallType.CUSTOM_COMMANDS);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, CondaCommands.class).setParameter("environment", (Object)CondaInstallType.ENVIRONMENT).setParameter("project", (Object)project).setParameter("customCommands", (Object)CondaInstallType.CUSTOM_COMMANDS);
        return this.findAll(offset, limit, filter, (Query)query, (Query)queryCount);
    }

    public AbstractFacade.CollectionInfo findAllLibCmdByProject(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort, Project project, String libName) {
        String queryStr = this.buildQuery("SELECT c FROM CondaCommands c ", filter, sort, "c.lib = :lib AND c.installType <> :installType AND c.projectId = :project ");
        String queryCountStr = this.buildQuery("SELECT COUNT(c.id) FROM CondaCommands c ", filter, sort, "c.lib = :lib AND c.installType <> :installType AND c.projectId = :project ");
        TypedQuery query = this.em.createQuery(queryStr, CondaCommands.class).setParameter("lib", (Object)libName).setParameter("installType", (Object)CondaInstallType.ENVIRONMENT).setParameter("project", (Object)project);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, CondaCommands.class).setParameter("lib", (Object)libName).setParameter("installType", (Object)CondaInstallType.ENVIRONMENT).setParameter("project", (Object)project);
        return this.findAll(offset, limit, filter, (Query)query, (Query)queryCount);
    }

    private AbstractFacade.CollectionInfo findAll(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Query query, Query queryCount) {
        this.setFilter(filter, query);
        this.setFilter(filter, queryCount);
        this.setOffsetAndLim(offset, limit, query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case OP: 
            case OP_NEQ: {
                this.setCondaOp(filterBy, q);
                break;
            }
            case STATUS: 
            case STATUS_NEQ: {
                this.setStatus(filterBy, q);
                break;
            }
            case HOST_IN: 
            case HOST_NIN: {
                this.setHosts(filterBy, q);
                break;
            }
            case HOST_LT: 
            case HOST_GT: {
                this.setHostsLTandGT(filterBy, q);
                break;
            }
        }
    }

    private void setCondaOp(AbstractFacade.FilterBy filterBy, Query q) {
        List ops = this.getEnumValues(filterBy, CondaOp.class);
        q.setParameter(filterBy.getField(), (Object)ops);
    }

    private void setStatus(AbstractFacade.FilterBy filterBy, Query q) {
        List status = this.getEnumValues(filterBy, CondaStatus.class);
        q.setParameter(filterBy.getField(), (Object)status);
    }

    private void setHosts(AbstractFacade.FilterBy filterBy, Query q) {
        List hosts = this.getIntValues(filterBy);
        q.setParameter(filterBy.getField(), (Object)hosts);
    }

    private void setHostsLTandGT(AbstractFacade.FilterBy filterBy, Query q) {
        Integer val = this.getIntValue(filterBy);
        q.setParameter(filterBy.getField(), (Object)val);
    }

    public static enum Filters {
        OP("OP", "c.op IN :op ", "op", "CREATE"),
        OP_NEQ("OP_NEQ", "c.op NOT IN :op_neq ", "op_neq", "CREATE"),
        STATUS("STATUS", "c.status IN :status ", "status", "NEW"),
        STATUS_NEQ("STATUS_NEQ", "c.status NOT IN :status_neq ", "status_neq", "NEW"),
        HOST_IN("HOST_IN", "c.hostId IN :hostId_in ", "hostId_in", "1"),
        HOST_NIN("HOST_NIN", "c.hostId NOT IN :hostId_nin ", "hostId_nin", "1"),
        HOST_LT("HOST_LT", "c.hostId < :hostId_lt ", "hostId_lt", "2"),
        HOST_GT("HOST_GT", "c.hostId > :hostId_gt ", "hostId_gt", "2");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", "c.id ", "ASC"),
        HOST("HOST", "c.hostId ", "ASC"),
        STATUS("STATUS", "c.status ", "ASC"),
        DATE_CREATED("DATE_CREATED", "c.created ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

