/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.user;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.user.BbcGroup;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@Stateless
public class BbcGroupFacade
extends AbstractFacade<BbcGroup> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public BbcGroupFacade() {
        super(BbcGroup.class);
    }

    public BbcGroup findByGroupName(String name) {
        try {
            return (BbcGroup)this.em.createNamedQuery("BbcGroup.findByGroupName", BbcGroup.class).setParameter("groupName", (Object)name).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<BbcGroup> findAll() {
        List allGroups = this.em.createNamedQuery("BbcGroup.findAll", BbcGroup.class).getResultList();
        ArrayList<BbcGroup> updated = new ArrayList<BbcGroup>();
        if (allGroups != null) {
            for (BbcGroup g : allGroups) {
                if (g.getGroupName().compareTo("AGENT") == 0) continue;
                updated.add(g);
            }
        }
        return updated;
    }

    public Integer lastGroupID() {
        Query query = this.em.createNativeQuery("SELECT MAX(b.gid) FROM hopsworks.bbc_group b");
        Object obj = query.getSingleResult();
        return (Integer)obj;
    }
}

