/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.embedding;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.hops.hopsworks.common.featurestore.embedding.VectorDatabaseClient;
import io.hops.hopsworks.common.featurestore.featuregroup.EmbeddingDTO;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Embedding;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.EmbeddingFeature;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.restutils.RESTCodes;
import io.hops.hopsworks.vectordb.Index;
import io.hops.hopsworks.vectordb.VectorDatabaseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class EmbeddingController {
    @EJB
    private Settings settings;
    @EJB
    private VectorDatabaseClient vectorDatabaseClient;

    public void createVectorDbIndex(Project project, Featuregroup featureGroup) throws FeaturestoreException {
        Index index = new Index(featureGroup.getEmbedding().getVectorDbIndexName());
        try {
            this.vectorDatabaseClient.getClient().createIndex(index, this.createIndex(featureGroup.getEmbedding().getColPrefix(), featureGroup.getEmbedding().getEmbeddingFeatures()), Boolean.valueOf(true));
            if (this.isDefaultVectorDbIndex(project, index.getName())) {
                this.vectorDatabaseClient.getClient().addFields(index, this.createMapping(featureGroup.getEmbedding().getColPrefix(), featureGroup.getEmbedding().getEmbeddingFeatures()));
            }
        }
        catch (VectorDatabaseException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_FEATUREGROUP, Level.FINE, "Cannot create opensearch vectordb index: " + index.getName());
        }
    }

    public Embedding getEmbedding(Project project, EmbeddingDTO embeddingDTO, Featuregroup featuregroup) throws FeaturestoreException {
        Embedding embedding = new Embedding();
        embedding.setFeaturegroup(featuregroup);
        if (embeddingDTO.getIndexName() == null) {
            embedding.setVectorDbIndexName(this.getDefaultVectorDbIndex(project));
            embedding.setColPrefix(this.getVectorDbColPrefix(featuregroup));
        } else {
            String vectorDbIndexPrefix = this.getVectorDbIndexPrefix(project);
            if (!embeddingDTO.getIndexName().startsWith(vectorDbIndexPrefix)) {
                embedding.setVectorDbIndexName(vectorDbIndexPrefix + "_" + embeddingDTO.getIndexName());
                embedding.setColPrefix("");
            }
            if (this.isDefaultVectorDbIndex(project, embeddingDTO.getIndexName())) {
                embedding.setColPrefix(this.getVectorDbColPrefix(featuregroup));
            }
        }
        embedding.setEmbeddingFeatures((Collection)embeddingDTO.getFeatures().stream().map(mapping -> new EmbeddingFeature(embedding, mapping.getName(), mapping.getDimension(), mapping.getSimilarityFunctionType())).collect(Collectors.toList()));
        return embedding;
    }

    protected String createMapping(String prefix, Collection<EmbeddingFeature> features) {
        String mappingString = "{\n    \"properties\": {\n%s\n    }\n  }";
        String fieldString = "        \"%s\": {\n          \"type\": \"knn_vector\",\n          \"dimension\": %d\n        }";
        ArrayList fieldMapping = Lists.newArrayList();
        for (EmbeddingFeature feature : features) {
            fieldMapping.add(String.format(fieldString, prefix + feature.getName(), feature.getDimension()));
        }
        return String.format(mappingString, String.join((CharSequence)",\n", fieldMapping));
    }

    protected String createIndex(String prefix, Collection<EmbeddingFeature> features) {
        String jsonString = "{\n  \"settings\": {\n    \"index\": {\n      \"knn\": \"true\",\n      \"knn.algo_param.ef_search\": 512\n    }\n  },\n  \"mappings\": %s\n}";
        return String.format(jsonString, this.createMapping(prefix, features));
    }

    private String getDefaultVectorDbIndex(Project project) throws FeaturestoreException {
        Set<String> indexName = this.getAllDefaultVectorDbIndex(project);
        return indexName.stream().sorted(Comparator.comparingInt(i -> new Random().nextInt())).findFirst().get();
    }

    private boolean isDefaultVectorDbIndex(Project project, String index) throws FeaturestoreException {
        return this.getAllDefaultVectorDbIndex(project).contains(index);
    }

    private Set<String> getAllDefaultVectorDbIndex(Project project) throws FeaturestoreException {
        Set<Object> indices;
        if (!Strings.isNullOrEmpty((String)this.settings.getOpensearchDefaultEmbeddingIndexName())) {
            indices = Arrays.stream(this.settings.getOpensearchDefaultEmbeddingIndexName().split(",")).collect(Collectors.toSet());
        } else {
            indices = Sets.newHashSet();
            for (int i = 0; i < this.settings.getOpensearchNumDefaultEmbeddingIndex(); ++i) {
                indices.add(this.getVectorDbIndexPrefix(project) + "_default_project_embedding_" + i);
            }
        }
        if (indices.size() == 0) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.OPENSEARCH_DEFAULT_EMBEDDING_INDEX_SUFFIX_NOT_DEFINED, Level.FINE, "Default vector db index is not defined.");
        }
        return indices;
    }

    private String getVectorDbIndexPrefix(Project project) {
        return project.getId() + "__embedding";
    }

    private String getVectorDbColPrefix(Featuregroup featuregroup) {
        return Utils.getFeaturegroupName(featuregroup) + "_";
    }
}

