/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.embedding;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.featurestore.embedding.EmbeddingController;
import io.hops.hopsworks.common.opensearch.OpenSearchClient;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.OpenSearchException;
import io.hops.hopsworks.restutils.RESTCodes;
import io.hops.hopsworks.vectordb.VectorDatabase;
import io.hops.hopsworks.vectordb.VectorDatabaseFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.opensearch.client.RestHighLevelClient;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class VectorDatabaseClient {
    @EJB
    private OpenSearchClient openSearchClient;
    private VectorDatabase vectorDatabase;
    private static final Logger LOG = Logger.getLogger(EmbeddingController.class.getName());

    public synchronized VectorDatabase getClient() throws FeaturestoreException {
        if (this.vectorDatabase == null) {
            try {
                this.vectorDatabase = VectorDatabaseFactory.getOpensearchDatabase((RestHighLevelClient)this.openSearchClient.getClient());
            }
            catch (ServiceDiscoveryException | OpenSearchException e) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_FEATUREGROUP, Level.FINE, "Cannot create opensearch vectordb");
            }
        }
        return this.vectorDatabase;
    }

    @PreDestroy
    private void close() {
        try {
            this.vectorDatabase.close();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }
}

