/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.s3;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.hops.hopsworks.common.featurestore.OptionDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.s3.FeaturestoreS3ConnectorEncryptionAlgorithm;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="featurestoreS3ConnectorDTO")
public class FeaturestoreS3ConnectorDTO
extends FeaturestoreStorageConnectorDTO {
    private String accessKey;
    private String secretKey;
    private String bucket;
    private String serverEncryptionAlgorithm;
    private String serverEncryptionKey;
    private String iamRole;
    private String sessionToken;
    private List<OptionDTO> arguments;

    public FeaturestoreS3ConnectorDTO() {
    }

    public FeaturestoreS3ConnectorDTO(FeaturestoreConnector featurestoreConnector) {
        super(featurestoreConnector);
        this.bucket = featurestoreConnector.getS3Connector().getBucket();
        this.serverEncryptionAlgorithm = this.getEncryptionAlgorithmName(featurestoreConnector.getS3Connector().getServerEncryptionAlgorithm());
        this.serverEncryptionKey = featurestoreConnector.getS3Connector().getServerEncryptionKey();
        this.iamRole = featurestoreConnector.getS3Connector().getIamRole();
    }

    private String getEncryptionAlgorithmName(FeaturestoreS3ConnectorEncryptionAlgorithm serverEncryptionAlgorithm) {
        if (serverEncryptionAlgorithm == null) {
            return null;
        }
        return serverEncryptionAlgorithm.getAlgorithm();
    }

    @XmlElement
    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @XmlElement
    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @XmlElement
    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @XmlElement
    public String getServerEncryptionAlgorithm() {
        return this.serverEncryptionAlgorithm;
    }

    public void setServerEncryptionAlgorithm(String serverEncryptionAlgorithm) {
        this.serverEncryptionAlgorithm = serverEncryptionAlgorithm;
    }

    @XmlElement
    public String getServerEncryptionKey() {
        return this.serverEncryptionKey;
    }

    public void setServerEncryptionKey(String serverEncryptionKey) {
        this.serverEncryptionKey = serverEncryptionKey;
    }

    @XmlElement
    public String getIamRole() {
        return this.iamRole;
    }

    public void setIamRole(String iamRole) {
        this.iamRole = iamRole;
    }

    @XmlElement
    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public List<OptionDTO> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<OptionDTO> arguments) {
        this.arguments = arguments;
    }

    @Override
    public String toString() {
        return "FeaturestoreS3ConnectorDTO{accessKey='" + this.accessKey + '\'' + ", secretKey='" + this.secretKey + '\'' + ", bucket='" + this.bucket + '\'' + ", serverEncryptionAlgorithm='" + this.serverEncryptionAlgorithm + '\'' + ", serverEncryptionKey='" + this.serverEncryptionKey + '\'' + '}';
    }
}

