/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.environment;

import com.google.common.base.Strings;
import freemarker.template.TemplateException;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.util.TemplateEngine;
import io.hops.hopsworks.common.util.templates.python.DockerCustomCommandsTemplate;
import io.hops.hopsworks.common.util.templates.python.DockerCustomCommandsTemplateBuilder;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.jupyter.config.GitBackend;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.CondaCommands;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class DockerFileController {
    private static final String DOCKER_HOST_NETWORK_OPT = "--network=host";
    private static final String DOCKER_NO_CACHE_OPT = "--no-cache";
    @EJB
    private Settings settings;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private SecretsController secretsController;
    @EJB
    private TemplateEngine templateEngine;

    public File createTmpDir(Project project) {
        File tmpDir = new File("/tmp/docker/" + project.getName());
        tmpDir.mkdirs();
        return tmpDir;
    }

    public File createNewImage(File cwd, String dockerFileName, String baseImage, CondaCommands cc) throws ServiceException {
        String anaconda_dir = this.settings.getAnacondaDir();
        File home = new File(System.getProperty("user.home"));
        File condarc = new File(home, ".condarc");
        File pip = new File(home, ".pip");
        try {
            FileUtils.copyFileToDirectory((File)condarc, (File)cwd);
            FileUtils.copyDirectoryToDirectory((File)pip, (File)cwd);
            File dockerFile = new File(cwd, dockerFileName);
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(dockerFile));){
                writer.write("FROM " + baseImage);
                writer.newLine();
                if (!Strings.isNullOrEmpty((String)cc.getEnvironmentFile())) {
                    writer.write("RUN rm -f /root/.condarc");
                    writer.newLine();
                    String environmentFilePath = cc.getEnvironmentFile();
                    String environmentFile = FilenameUtils.getName((String)environmentFilePath);
                    writer.write("COPY .condarc .pip " + environmentFile + " /root/");
                    writer.newLine();
                    this.copyCondaArtifactToLocal(environmentFilePath, cwd + File.separator + environmentFile);
                    String anaconda_project_dir = anaconda_dir + "/envs/" + this.settings.getCurrentCondaEnvironment();
                    if (environmentFilePath.endsWith(".yml")) {
                        if (cc.getInstallJupyter().booleanValue()) {
                            writer.write("RUN conda env update -f /root/" + environmentFile + " -n " + this.settings.getCurrentCondaEnvironment());
                        } else {
                            writer.write("RUN conda env create -f /root/" + environmentFile + " -p " + anaconda_project_dir);
                        }
                    } else if (environmentFilePath.endsWith("/requirements.txt")) {
                        if (cc.getInstallJupyter().booleanValue()) {
                            writer.write("RUN pip install -r /root/" + environmentFile);
                        } else {
                            writer.write("RUN conda create -y -p " + anaconda_project_dir + " python=" + this.settings.getDockerBaseImagePythonVersion() + " && pip install -r /root/" + environmentFile);
                        }
                    }
                    writer.write(" && " + this.getCleanupCommand(anaconda_dir) + " && " + anaconda_dir + "/bin/conda list -n " + this.settings.getCurrentCondaEnvironment());
                }
            }
            return dockerFile;
        }
        catch (IOException e) {
            String errorMsg = "Failed to write docker file";
            throw new ServiceException(RESTCodes.ServiceErrorCode.LOCAL_FILESYSTEM_ERROR, Level.INFO, errorMsg, errorMsg, (Throwable)e);
        }
    }

    public BuildImageDetails installLibrary(File baseDir, String dockerFileName, String baseImage, CondaCommands cc) throws UserException, ServiceException {
        String anaconda_dir = this.settings.getAnacondaDir();
        String anaconda_project_dir = anaconda_dir + "/envs/" + this.settings.getCurrentCondaEnvironment();
        ArrayList<String> dockerBuildOpts = new ArrayList<String>();
        dockerBuildOpts.add(DOCKER_HOST_NETWORK_OPT);
        File home = new File(System.getProperty("user.home"));
        File condarc = new File(home, ".condarc");
        File pip = new File(home, ".pip");
        try {
            FileUtils.copyFileToDirectory((File)condarc, (File)baseDir);
            FileUtils.copyDirectoryToDirectory((File)pip, (File)baseDir);
            File dockerFile = new File(baseDir, dockerFileName);
            String apiToken = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(dockerFile));){
                writer.write("FROM " + baseImage);
                writer.newLine();
                writer.write("RUN --mount=type=bind,source=.condarc,target=/root/.condarc --mount=type=bind,source=.pip,target=/root/.pip ");
                switch (cc.getInstallType()) {
                    case CONDA: {
                        String condaLib;
                        if (cc.getVersion().equals("UNKNOWN")) {
                            condaLib = cc.getLib();
                            dockerBuildOpts.add(DOCKER_NO_CACHE_OPT);
                        } else {
                            condaLib = cc.getLib() + "=" + cc.getVersion();
                        }
                        writer.write(anaconda_dir + "/bin/conda install -y -n " + this.settings.getCurrentCondaEnvironment() + " -c " + cc.getChannelUrl() + " " + condaLib);
                        break;
                    }
                    case PIP: {
                        String pipLib;
                        if (cc.getVersion().equals("UNKNOWN")) {
                            pipLib = cc.getLib();
                            dockerBuildOpts.add(DOCKER_NO_CACHE_OPT);
                        } else {
                            pipLib = cc.getLib() + "==" + cc.getVersion();
                        }
                        writer.write(anaconda_project_dir + "/bin/pip install --upgrade " + pipLib);
                        break;
                    }
                    case EGG: {
                        String eggName = cc.getLib();
                        String localEggPath = baseDir + File.separator + eggName;
                        this.copyCondaArtifactToLocal(cc.getArg(), localEggPath);
                        writer.write("--mount=type=bind,source=" + eggName + ",target=/root/" + eggName + " ");
                        writer.write(anaconda_project_dir + "/bin/easy_install --upgrade /root/" + eggName);
                        break;
                    }
                    case WHEEL: {
                        String wheelName = cc.getLib();
                        String localWheelPath = baseDir + File.separator + wheelName;
                        this.copyCondaArtifactToLocal(cc.getArg(), localWheelPath);
                        writer.write("--mount=type=bind,source=" + wheelName + ",target=/root/" + wheelName + " ");
                        writer.write(anaconda_project_dir + "/bin/pip install --upgrade /root/" + wheelName);
                        break;
                    }
                    case REQUIREMENTS_TXT: {
                        String requirementsName = cc.getLib();
                        String localRequirementsName = baseDir + File.separator + requirementsName;
                        this.copyCondaArtifactToLocal(cc.getArg(), localRequirementsName);
                        writer.write("--mount=type=bind,source=" + requirementsName + ",target=/root/" + requirementsName + " ");
                        writer.write(anaconda_project_dir + "/bin/pip install -r /root/" + requirementsName);
                        break;
                    }
                    case ENVIRONMENT_YAML: {
                        String environmentsName = cc.getLib();
                        String localEnvironmentsName = baseDir + File.separator + environmentsName;
                        this.copyCondaArtifactToLocal(cc.getArg(), localEnvironmentsName);
                        writer.write("--mount=type=bind,source=" + environmentsName + ",target=/root/" + environmentsName + " ");
                        writer.write(anaconda_dir + "/bin/conda env update -f /root/" + environmentsName + " -n " + this.settings.getCurrentCondaEnvironment());
                        break;
                    }
                    case GIT: {
                        if (cc.getGitBackend() != null && cc.getGitApiKeyName() != null) {
                            apiToken = this.secretsController.get(cc.getUserId(), cc.getGitApiKeyName()).getPlaintext();
                            URL repoUrl = new URL(cc.getArg());
                            if (cc.getGitBackend().equals((Object)GitBackend.GITHUB)) {
                                writer.write(anaconda_project_dir + "/bin/pip install --upgrade 'git+https://" + apiToken + ":x-oauth-basic@" + repoUrl.getHost() + repoUrl.getPath() + "'");
                            } else if (cc.getGitBackend().equals((Object)GitBackend.GITLAB)) {
                                writer.write(anaconda_project_dir + "/bin/pip install --upgrade 'git+https://oauth2:" + apiToken + "@" + repoUrl.getHost() + repoUrl.getPath() + "'");
                            }
                        } else if (cc.getArg().startsWith("https://")) {
                            writer.write(anaconda_project_dir + "/bin/pip install --upgrade 'git+" + cc.getArg() + "'");
                        } else {
                            writer.write(anaconda_project_dir + "/bin/pip install --upgrade '" + cc.getArg() + "'");
                        }
                        dockerBuildOpts.add(DOCKER_NO_CACHE_OPT);
                        break;
                    }
                    case CUSTOM_COMMANDS: {
                        this.copyCustomCommandsArtifactsToLocal(baseDir.getPath(), cc);
                        this.customCommandsDockerfile(writer, cc, baseDir);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("install type unknown: " + cc.getInstallType());
                    }
                }
                writer.write(" &&  change_library_ownership.sh && " + this.getCleanupCommand(anaconda_dir) + " && " + anaconda_dir + "/bin/conda list -n " + this.settings.getCurrentCondaEnvironment());
            }
            return new BuildImageDetails(dockerFile, dockerBuildOpts, cc.getGitApiKeyName(), apiToken);
        }
        catch (IOException e) {
            String errorMsg = "Failed to write docker file";
            throw new ServiceException(RESTCodes.ServiceErrorCode.LOCAL_FILESYSTEM_ERROR, Level.INFO, errorMsg, errorMsg, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File uninstallLibrary(File baseDir, String baseImage, CondaCommands cc) throws ServiceException {
        String anaconda_dir = this.settings.getAnacondaDir();
        String anaconda_project_dir = anaconda_dir + "/envs/" + this.settings.getCurrentCondaEnvironment();
        File dockerFile = new File(baseDir, "dockerFile_" + cc.getProjectId().getName());
        File home = new File(System.getProperty("user.home"));
        try {
            FileUtils.copyFileToDirectory((File)new File(home, ".condarc"), (File)baseDir);
            FileUtils.copyDirectoryToDirectory((File)new File(home, ".pip"), (File)baseDir);
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(dockerFile));){
                writer.write("FROM " + baseImage + "\n");
                writer.newLine();
                writer.write("RUN --mount=type=bind,source=.condarc,target=/root/.condarc --mount=type=bind,source=.pip,target=/root/.pip ");
                switch (cc.getInstallType()) {
                    case CONDA: {
                        writer.write(anaconda_dir + "/bin/conda remove -y -n " + this.settings.getCurrentCondaEnvironment() + " " + cc.getLib() + " || true\n");
                        return dockerFile;
                    }
                    case PIP: {
                        writer.write(anaconda_project_dir + "/bin/pip uninstall -y " + cc.getLib() + " || true\n");
                        return dockerFile;
                    }
                    default: {
                        throw new UnsupportedOperationException("install type unknown: " + cc.getInstallType());
                    }
                }
            }
        }
        catch (IOException e) {
            String errorMsg = "Failed to write docker file";
            throw new ServiceException(RESTCodes.ServiceErrorCode.LOCAL_FILESYSTEM_ERROR, Level.INFO, errorMsg, errorMsg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCondaArtifactToLocal(String source, String destPath) throws IOException {
        try (DistributedFileSystemOps dfso = null;){
            dfso = this.dfs.getDfsOps();
            dfso.copyToLocal(source, destPath);
        }
    }

    public void customCommandsDockerfile(BufferedWriter writer, CondaCommands cc, File baseDir) throws IOException {
        File bashScript = new File(cc.getCustomCommandsFile());
        DockerCustomCommandsTemplate template = DockerCustomCommandsTemplateBuilder.newBuilder().setCommandScript(bashScript.getName()).build();
        File dockerCommandsFile = new File(baseDir, "docker_commands_generated");
        if (!dockerCommandsFile.exists()) {
            try (FileWriter out = new FileWriter(dockerCommandsFile, false);){
                HashMap<String, Object> dataModel = new HashMap<String, Object>(1);
                dataModel.put("args", template);
                try {
                    this.templateEngine.template("custom_docker_commands_template", dataModel, out);
                }
                catch (TemplateException ex) {
                    throw new IOException(ex);
                }
            }
        }
        String dockerCommands = new String(Files.readAllBytes(Paths.get(dockerCommandsFile.toString(), new String[0])));
        writer.write("\n\n" + dockerCommands + "\n\n");
        writer.write("RUN echo '' ");
        try {
            Files.delete(Paths.get(dockerCommandsFile.toString(), new String[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCustomCommandsArtifactsToLocal(String destPath, CondaCommands cc) throws IOException {
        try (DistributedFileSystemOps dfso = null;){
            dfso = this.dfs.getDfsOps();
            ArrayList<String> artifacts = new ArrayList<String>();
            artifacts.add(cc.getCustomCommandsFile());
            if (!Strings.isNullOrEmpty((String)cc.getArg())) {
                artifacts.addAll(Arrays.asList(cc.getArg().split(",")));
            }
            for (String artifact : artifacts) {
                dfso.copyToLocal(artifact, destPath);
            }
        }
    }

    private String getCleanupCommand(String anaconda_dir) {
        return anaconda_dir + "/bin/conda clean -afy && rm -rf ~/.cache && rm -rf /usr/local/share/.cache";
    }

    public static class BuildImageDetails {
        public final File dockerFile;
        public final ArrayList<String> dockerBuildOpts;
        public final String gitApiKeyName;
        public final String gitApiToken;

        public BuildImageDetails(File dockerFile, ArrayList<String> dockerBuildOpts, String gitApiKeyName, String gitApiToken) {
            this.dockerFile = dockerFile;
            this.dockerBuildOpts = dockerBuildOpts;
            this.gitApiKeyName = gitApiKeyName;
            this.gitApiToken = gitApiToken;
        }
    }
}

