/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.project;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class ProjectFacade
extends AbstractFacade<Project> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public ProjectFacade() {
        super(Project.class);
    }

    public List<Project> findAll() {
        TypedQuery query = this.em.createNamedQuery("Project.findAll", Project.class);
        return query.getResultList();
    }

    public List<Project> findAllOrderByCreated() {
        TypedQuery query = this.em.createNamedQuery("Project.findAllOrderByCreated", Project.class);
        return query.getResultList();
    }

    public Project find(Integer id) {
        return (Project)this.em.find(Project.class, (Object)id);
    }

    public List<Project> findByUser(Users user) {
        TypedQuery query = this.em.createNamedQuery("Project.findByOwner", Project.class).setParameter("owner", (Object)user);
        return query.getResultList();
    }

    public List<Project> findByUser(String email) {
        TypedQuery query = this.em.createNamedQuery("Users.findByEmail", Users.class).setParameter("email", (Object)email);
        Users user = (Users)query.getSingleResult();
        return this.findByUser(user);
    }

    public Project findByNameAndOwner(String projectname, Users user) {
        TypedQuery query = this.em.createNamedQuery("Project.findByOwnerAndName", Project.class).setParameter("name", (Object)projectname).setParameter("owner", (Object)user);
        try {
            return (Project)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Project findByNameAndOwnerEmail(String projectname, String email) {
        TypedQuery query = this.em.createNamedQuery("Users.findByEmail", Users.class).setParameter("email", (Object)email);
        Users user = (Users)query.getSingleResult();
        return this.findByNameAndOwner(projectname, user);
    }

    public String findOwner(Project project) {
        return project.getOwner().getEmail();
    }

    public List<Project> findAllMemberStudies(Users user) {
        TypedQuery query = this.em.createNamedQuery("ProjectTeam.findAllMemberStudiesForUser", Project.class);
        query.setParameter("user", (Object)user);
        return query.getResultList();
    }

    public List<Project> findAllPersonalStudies(Users user) {
        TypedQuery query = this.em.createNamedQuery("Project.findByOwner", Project.class);
        query.setParameter("owner", (Object)user);
        return query.getResultList();
    }

    public List<Project> findAllJoinedStudies(Users user) {
        TypedQuery query = this.em.createNamedQuery("ProjectTeam.findAllJoinedStudiesForUser", Project.class);
        query.setParameter("user", (Object)user);
        return query.getResultList();
    }

    public void persistProject(Project project) {
        this.em.persist((Object)project);
    }

    public void flushEm() {
        this.em.flush();
    }

    public boolean projectExists(String name) {
        return !this.em.createNamedQuery("Project.findByNameCaseInsensitive", Project.class).setParameter("name", (Object)name).getResultList().isEmpty();
    }

    public boolean projectExistsForOwner(String name, Users owner) {
        TypedQuery query = this.em.createNamedQuery("Project.findByOwnerAndName", Project.class);
        query.setParameter("owner", (Object)owner).setParameter("name", (Object)name);
        return !query.getResultList().isEmpty();
    }

    public void mergeProject(Project newProject) {
        this.em.merge((Object)newProject);
    }

    public void setDockerImage(Project project, String dockerImage) {
        project.setDockerImage(dockerImage);
        this.em.merge((Object)project);
    }

    public Optional<Project> findById(Integer id) {
        return Optional.ofNullable(this.em.createNamedQuery("Project.findById", Project.class).setParameter("id", (Object)id).getSingleResult());
    }

    public Project findByName(String name) {
        TypedQuery query = this.em.createNamedQuery("Project.findByName", Project.class);
        query.setParameter("name", (Object)name);
        try {
            return (Project)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Project findByNameCaseInsensitive(String name) {
        TypedQuery query = this.em.createNamedQuery("Project.findByNameCaseInsensitive", Project.class);
        query.setParameter("name", (Object)name);
        try {
            return (Project)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public boolean numProjectsLimitReached(Users user) {
        return user.getMaxNumProjects() >= 0 && user.getNumActiveProjects() >= user.getMaxNumProjects();
    }

    public void setTimestampQuotaUpdate(Project project, Date timestamp) {
        project.setLastQuotaUpdate(timestamp);
        this.em.merge((Object)project);
        this.em.flush();
    }

    public void changeKafkaQuota(Project project, int numTopics) {
        project.setKafkaMaxNumTopics(Integer.valueOf(numTopics));
        this.em.merge((Object)project);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void removeProject(String projectName) {
        Project proj = this.findByName(projectName);
        if (proj != null) {
            this.em.remove((Object)proj);
        }
    }
}

