/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dataset.util;

import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.hadoop.fs.Path;

public class DatasetPath {
    private final Path fullPath;
    private final Path datasetFullPath;
    private final Path relativePath;
    private boolean isShared;
    private Dataset dataset;
    private DatasetSharedWith datasetSharedWith;
    private Inode inode;
    private static final String FILE_SEPARATOR = "/";

    public DatasetPath(Path fullPath, Path datasetFullPath, Path relativePath) {
        this.fullPath = fullPath;
        this.datasetFullPath = datasetFullPath;
        this.relativePath = relativePath;
    }

    public DatasetPath(Project project, String path, String root) throws UnsupportedEncodingException {
        String projectName;
        String p = Utils.prepPath(path);
        String pathStr = Utils.pathStripSlash(p);
        String pathRoot = Utils.pathStripSlash(root);
        boolean isProject = root.equals("Projects");
        this.isShared = pathStr.contains("::");
        String dataset = this.getDatasetFromPath(pathStr, pathRoot, project.getName(), isProject);
        String datasetName = !dataset.isEmpty() && dataset.contains(FILE_SEPARATOR) ? dataset.split(FILE_SEPARATOR)[0] : dataset;
        String string = projectName = isProject ? FILE_SEPARATOR + project.getName() + FILE_SEPARATOR : FILE_SEPARATOR;
        if (pathStr.startsWith(pathRoot + FILE_SEPARATOR) && !datasetName.contains("::")) {
            this.fullPath = new Path(FILE_SEPARATOR + pathStr);
        } else if (!datasetName.contains("::")) {
            this.fullPath = new Path(FILE_SEPARATOR + pathRoot + projectName + pathStr);
        } else {
            String[] datasetNameParts = datasetName.split("::");
            String string2 = projectName = isProject ? FILE_SEPARATOR + datasetNameParts[0] + FILE_SEPARATOR : FILE_SEPARATOR;
            if (projectName.replaceAll(FILE_SEPARATOR, "").equals(project.getName())) {
                this.isShared = false;
                dataset = dataset.replace(datasetName, datasetNameParts[1]);
            }
            this.fullPath = new Path(FILE_SEPARATOR + pathRoot + projectName + dataset.replace(datasetName, datasetNameParts[1]));
        }
        this.relativePath = new Path(FILE_SEPARATOR + dataset);
        this.datasetFullPath = this.getDatasetPath(this.fullPath.toString(), new Path(pathRoot + projectName));
    }

    public Path getFullPath() {
        return this.fullPath;
    }

    public Path getDatasetFullPath() {
        return this.datasetFullPath;
    }

    public Path getRelativePath() {
        return this.relativePath;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public DatasetSharedWith getDatasetSharedWith() {
        return this.datasetSharedWith;
    }

    public void setDatasetSharedWith(DatasetSharedWith datasetSharedWith) {
        this.datasetSharedWith = datasetSharedWith;
        this.isShared = true;
    }

    public Inode getInode() {
        return this.inode;
    }

    public void setInode(Inode inode) {
        this.inode = inode;
    }

    public boolean isTopLevelDataset() {
        return this.fullPath.depth() == this.datasetFullPath.depth();
    }

    public String getDatasetRelativePath() {
        return Utils.pathStripSlash(this.fullPath.toString().replace(this.datasetFullPath.toString(), ""));
    }

    public String getDatasetName() {
        return this.datasetFullPath.getName();
    }

    public boolean isShared() {
        return this.isShared;
    }

    private String getDatasetFromPath(String path, String root, String projectName, boolean isProject) {
        String dataset = path;
        if (path.startsWith(root)) {
            dataset = path.replace(root + FILE_SEPARATOR, "");
            if (isProject && dataset.startsWith(projectName)) {
                dataset = dataset.replace(projectName + FILE_SEPARATOR, "");
            } else if (isProject) {
                dataset = dataset.substring(dataset.indexOf(FILE_SEPARATOR) + 1);
            }
        }
        return dataset;
    }

    private Path getDatasetPath(String fullPath, Path root) {
        if (fullPath.startsWith(FILE_SEPARATOR)) {
            fullPath = fullPath.substring(1);
        }
        String[] parts = fullPath.split(FILE_SEPARATOR);
        String dsPath = String.join((CharSequence)FILE_SEPARATOR, Arrays.copyOfRange(parts, 0, root.depth() + 1));
        return new Path(FILE_SEPARATOR + dsPath);
    }

    public Project getAccessProject() {
        return this.isShared ? this.datasetSharedWith.getProject() : this.dataset.getProject();
    }
}

