/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.gcs;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretsFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.StorageConnectorUtil;
import io.hops.hopsworks.common.featurestore.storageconnectors.gcs.EncryptionSecrets;
import io.hops.hopsworks.common.featurestore.storageconnectors.gcs.FeatureStoreGcsConnectorDTO;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.gcs.FeatureStoreGcsConnector;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.secrets.Secret;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.transaction.Transactional;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeatureStoreGcsConnectorController {
    private static final Logger LOGGER = Logger.getLogger(FeatureStoreGcsConnectorController.class.getName());
    @EJB
    private StorageConnectorUtil storageConnectorUtil;
    @EJB
    private SecretsFacade secretsFacade;

    public FeatureStoreGcsConnectorController() {
    }

    public FeatureStoreGcsConnectorController(StorageConnectorUtil storageConnectorUtil) {
        this.storageConnectorUtil = storageConnectorUtil;
    }

    public FeatureStoreGcsConnectorDTO getConnector(FeaturestoreConnector featurestoreConnector) throws FeaturestoreException {
        FeatureStoreGcsConnectorDTO gcsConnectorDTO = new FeatureStoreGcsConnectorDTO(featurestoreConnector);
        gcsConnectorDTO.setKeyPath(featurestoreConnector.getGcsConnector().getKeyPath());
        gcsConnectorDTO.setBucket(featurestoreConnector.getGcsConnector().getBucket());
        if (featurestoreConnector.getGcsConnector().getEncryptionSecret() != null) {
            EncryptionSecrets encryptionSecrets = this.storageConnectorUtil.getSecret(featurestoreConnector.getGcsConnector().getEncryptionSecret(), EncryptionSecrets.class);
            gcsConnectorDTO.setEncryptionKey(encryptionSecrets.getEncryptionKey());
            gcsConnectorDTO.setEncryptionKeyHash(encryptionSecrets.getEncryptionKeyHash());
        }
        return gcsConnectorDTO;
    }

    public FeatureStoreGcsConnector createConnector(Project project, Users user, Featurestore featureStore, FeatureStoreGcsConnectorDTO gcsConnectorDTO) throws FeaturestoreException, ProjectException, UserException {
        this.validateInput(project, user, gcsConnectorDTO);
        FeatureStoreGcsConnector gcsConnector = new FeatureStoreGcsConnector();
        gcsConnector.setKeyPath(gcsConnectorDTO.getKeyPath());
        gcsConnector.setAlgorithm(gcsConnectorDTO.getAlgorithm());
        gcsConnector.setBucket(gcsConnectorDTO.getBucket());
        this.updateSecret(user, gcsConnectorDTO, featureStore, gcsConnector);
        return gcsConnector;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Transactional(rollbackOn={FeaturestoreException.class})
    public FeatureStoreGcsConnector updateConnector(Project project, Users user, Featurestore featureStore, FeatureStoreGcsConnectorDTO gcsConnectorDTO, FeatureStoreGcsConnector gcsConnector) throws FeaturestoreException, ProjectException, UserException {
        this.validateInput(project, user, gcsConnectorDTO);
        gcsConnector.setKeyPath(gcsConnectorDTO.getKeyPath());
        gcsConnector.setAlgorithm(gcsConnectorDTO.getAlgorithm());
        gcsConnector.setBucket(gcsConnectorDTO.getBucket());
        this.updateSecret(user, gcsConnectorDTO, featureStore, gcsConnector);
        return gcsConnector;
    }

    private void updateSecret(Users user, FeatureStoreGcsConnectorDTO gcsConnectorDTO, Featurestore featureStore, FeatureStoreGcsConnector gcsConnector) throws UserException, ProjectException {
        Secret secret = gcsConnector.getEncryptionSecret();
        if (gcsConnectorDTO.getAlgorithm() != null) {
            String secretName = secret != null ? secret.getId().getName() : this.storageConnectorUtil.createSecretName(featureStore.getId(), gcsConnectorDTO.getName(), gcsConnectorDTO.getStorageConnectorType());
            EncryptionSecrets secretsClass = new EncryptionSecrets(gcsConnectorDTO.getEncryptionKey(), gcsConnectorDTO.getEncryptionKeyHash());
            gcsConnector.setEncryptionSecret(this.storageConnectorUtil.updateProjectSecret(user, gcsConnector.getEncryptionSecret(), secretName, featureStore, secretsClass));
        } else {
            gcsConnector.setEncryptionSecret(null);
        }
        if (gcsConnector.getEncryptionSecret() == null && secret != null) {
            this.secretsFacade.deleteSecret(secret.getId());
        }
    }

    public void validateInput(Project project, Users user, FeatureStoreGcsConnectorDTO gcsConnectorDTO) throws FeaturestoreException {
        this.storageConnectorUtil.validatePath(project, user, gcsConnectorDTO.getKeyPath(), "Key file path");
        if (Strings.isNullOrEmpty((String)gcsConnectorDTO.getKeyPath())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.GCS_FIELD_MISSING, Level.FINE, "Key File Path cannot be empty");
        }
        if (Strings.isNullOrEmpty((String)gcsConnectorDTO.getBucket())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.GCS_FIELD_MISSING, Level.FINE, "Bucket cannot be empty");
        }
        if (!(Strings.isNullOrEmpty((String)gcsConnectorDTO.getEncryptionKey()) && Strings.isNullOrEmpty((String)gcsConnectorDTO.getEncryptionKeyHash()) && gcsConnectorDTO.getAlgorithm() == null || !Strings.isNullOrEmpty((String)gcsConnectorDTO.getEncryptionKey()) && !Strings.isNullOrEmpty((String)gcsConnectorDTO.getEncryptionKeyHash()) && gcsConnectorDTO.getAlgorithm() != null)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.GCS_FIELD_MISSING, Level.FINE, "Encryption algorithm, key and key hash have all to be set or all to be null, you provided: algorithm=" + gcsConnectorDTO.getAlgorithm() + ", key=" + gcsConnectorDTO.getEncryptionKey() + ", hashKey=" + gcsConnectorDTO.getEncryptionKeyHash());
        }
    }
}

