/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.git.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import freemarker.template.TemplateException;
import io.hops.hopsworks.common.dao.git.GitPaths;
import io.hops.hopsworks.common.git.BasicAuthSecrets;
import io.hops.hopsworks.common.git.GitJWTManager;
import io.hops.hopsworks.common.git.util.GitCommandOperationUtil;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.util.TemplateEngine;
import io.hops.hopsworks.common.util.templates.git.GitContainerLaunchScriptArgumentTemplateBuilder;
import io.hops.hopsworks.common.util.templates.git.GitContainerLaunchScriptArgumentsTemplate;
import io.hops.hopsworks.persistence.entity.git.GitOpExecution;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class GitContainerArgumentsWriter {
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private ProjectUtils projectUtils;
    @EJB
    private GitCommandOperationUtil gitCommandOperationUtil;
    @EJB
    private GitJWTManager gitJWTManager;
    @EJB
    private Settings settings;
    @EJB
    private TemplateEngine templateEngine;
    private ObjectMapper objectMapper;

    @PostConstruct
    public void init() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new JaxbAnnotationModule());
    }

    public void createArgumentFile(GitOpExecution gitOpExecution, GitPaths gitPaths, BasicAuthSecrets authSecrets) throws ServiceDiscoveryException, IOException {
        File argumentsFile = new File(gitPaths.getConfDirPath(), "git_container_launch_script_arguments");
        if (!argumentsFile.exists()) {
            try (FileWriter out = new FileWriter(argumentsFile, false);){
                this.writeTemplateToFile(out, this.setUpTemplate(gitOpExecution, gitPaths, authSecrets));
            }
        }
    }

    private void writeTemplateToFile(Writer out, GitContainerLaunchScriptArgumentsTemplate template) throws IOException {
        HashMap<String, Object> dataModel = new HashMap<String, Object>(1);
        dataModel.put("args", template);
        try {
            this.templateEngine.template("git_container_launch_script_arguments_template", dataModel, out);
        }
        catch (TemplateException ex) {
            throw new IOException(ex);
        }
    }

    private GitContainerLaunchScriptArgumentsTemplate setUpTemplate(GitOpExecution gitOpExecution, GitPaths gitPaths, BasicAuthSecrets authSecrets) throws ServiceDiscoveryException, JsonProcessingException {
        String hdfsUser = this.hdfsUsersController.getHdfsUserName(gitOpExecution.getRepository().getProject(), gitOpExecution.getUser());
        String fullCommandLogFilePath = this.gitCommandOperationUtil.getLogFileFullPath(gitOpExecution, gitPaths.getLogDirPath(), hdfsUser, "command_output.log");
        String fullHopsfsMountLogFilePath = this.gitCommandOperationUtil.getLogFileFullPath(gitOpExecution, gitPaths.getLogDirPath(), hdfsUser, "hopsfs_mount.log");
        String gitCommand = gitOpExecution.getGitCommandConfiguration().getCommandType().getGitCommand();
        return GitContainerLaunchScriptArgumentTemplateBuilder.newBuilder().setGitHome(gitPaths.getGitPath()).setHdfsUser(hdfsUser).setCertificatesDir(gitPaths.getCertificatesDirPath()).setImageName(this.projectUtils.getFullDockerImageName(this.settings.getGitImageName())).setCommandLogFile(fullCommandLogFilePath).setHopsfsMountLogFile(fullHopsfsMountLogFilePath).setProjectName(gitOpExecution.getRepository().getProject().getName()).setGitCommand(gitCommand).setCommandConfiguration(this.objectMapper.writeValueAsString((Object)gitOpExecution.getGitCommandConfiguration())).setTokenPath(this.gitJWTManager.getTokenFullPath(gitPaths.getTokenPath()).toString()).setExecutionId(String.valueOf(gitOpExecution.getId())).setProjectId(String.valueOf(gitOpExecution.getRepository().getProject().getId())).setGitUsername(authSecrets.getUsername()).setGitToken(authSecrets.getPassword()).setRepositoryId(String.valueOf(gitOpExecution.getRepository().getId())).build();
    }
}

