/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security;

import io.hops.hopsworks.common.dao.certificates.CertsFacade;
import io.hops.hopsworks.common.proxies.CAProxy;
import io.hops.hopsworks.common.security.CSR;
import io.hops.hopsworks.common.security.CertificateHandler;
import io.hops.hopsworks.common.security.CertificatesMgmService;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.persistence.entity.certificates.UserCerts;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeam;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.javatuples.Pair;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NEVER)
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class CertificatesController {
    private static final Logger LOGGER = Logger.getLogger(CertificatesController.class.getName());
    private static final String SECURITY_PROVIDER = "BC";
    private static final String KEY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String CERTIFICATE_TYPE = "X.509";
    private static final int KEY_SIZE = 2048;
    @EJB
    private CertsFacade certsFacade;
    @EJB
    private CertificatesMgmService certificatesMgmService;
    @Inject
    @Any
    private Instance<CertificateHandler> certificateHandlers;
    @EJB
    private CAProxy caProxy;
    @EJB
    private ProjectUtils projectUtils;
    private KeyPairGenerator keyPairGenerator = null;
    private CertificateFactory certificateFactory = null;

    @PostConstruct
    public void init() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            this.keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM, SECURITY_PROVIDER);
            this.keyPairGenerator.initialize(2048);
            this.certificateFactory = CertificateFactory.getInstance(CERTIFICATE_TYPE);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not initialize the key generator", e);
        }
    }

    @Asynchronous
    public Future<CertsResult> generateCertificates(Project project, Users user) throws Exception {
        String userKeyPwd = HopsUtils.randomString(64);
        String encryptedKey = HopsUtils.encrypt(user.getPassword(), userKeyPwd, this.certificatesMgmService.getMasterEncryptionPassword());
        Pair<KeyStore, KeyStore> userKeystores = this.generateStores(project.getName() + "__" + user.getUsername(), userKeyPwd, Endpoint.PROJECT);
        UserCerts uc = this.certsFacade.putUserCerts(project.getName(), user.getUsername(), this.convertKeystoreToByteArray((KeyStore)userKeystores.getValue0(), userKeyPwd), this.convertKeystoreToByteArray((KeyStore)userKeystores.getValue1(), userKeyPwd), encryptedKey);
        for (CertificateHandler certificateHandler : this.certificateHandlers) {
            certificateHandler.generate(project, user, uc);
        }
        LOGGER.log(Level.FINE, "Created project generic certificates for project: " + project.getName());
        return new AsyncResult((Object)new CertsResult(project.getName(), user.getUsername()));
    }

    public void revokeProjectCertificates(Project project) throws GenericException, HopsSecurityException, IOException {
        this.revokeProjectCertificates(project, null);
    }

    public void revokeProjectCertificates(Project project, Users owner) throws GenericException, HopsSecurityException, IOException {
        String projectName = project.getName();
        Set users2deleteCertificates = Optional.ofNullable(this.projectUtils.getProjectTeamCollection(project)).map(Collection::stream).orElse(Stream.empty()).map(ProjectTeam::getUser).collect(Collectors.toSet());
        if (owner != null) {
            users2deleteCertificates.add(owner);
        }
        for (Users user2delete : users2deleteCertificates) {
            String certificateIdentifier = projectName + "__" + user2delete.getUsername();
            this.revokeCertificate(certificateIdentifier, Endpoint.PROJECT);
            for (CertificateHandler certificateHandler : this.certificateHandlers) {
                certificateHandler.revoke(project, user2delete);
            }
        }
    }

    public void revokeUserSpecificCertificates(Project project, Users user) throws GenericException, HopsSecurityException, IOException {
        String certificateIdentifier = project.getName() + "__" + user.getUsername();
        this.certsFacade.removeUserProjectCerts(project.getName(), user.getUsername());
        this.revokeCertificate(certificateIdentifier, Endpoint.PROJECT);
        for (CertificateHandler certificateHandler : this.certificateHandlers) {
            certificateHandler.revoke(project, user);
        }
    }

    public BigInteger extractSerialNumberFromCert(String certificate) throws CertificateException {
        ByteArrayInputStream certStream = new ByteArrayInputStream(certificate.getBytes());
        CertificateFactory cf = CertificateFactory.getInstance(CERTIFICATE_TYPE);
        X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(certStream);
        return x509Certificate.getSerialNumber();
    }

    public X500Name extractSubjectFromCSR(String csr) throws IOException {
        PemReader pemReader = new PemReader((Reader)new StringReader(csr));
        PemObject pemObject = pemReader.readPemObject();
        pemReader.close();
        PKCS10CertificationRequest csrObject = new PKCS10CertificationRequest(pemObject.getContent());
        return csrObject.getSubject();
    }

    private byte[] convertKeystoreToByteArray(KeyStore keyStore, String password) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        ByteArrayOutputStream keyStoreStream = new ByteArrayOutputStream();
        keyStore.store(keyStoreStream, password.toCharArray());
        return keyStoreStream.toByteArray();
    }

    private Pair<KeyStore, KeyStore> generateStores(String CN, String userKeyPwd, Endpoint endpoint) throws HopsSecurityException, GenericException {
        try {
            LOGGER.log(Level.INFO, "Generating keypair for " + CN);
            KeyPair keyPair = this.keyPairGenerator.generateKeyPair();
            CSR csr = this.generateCSR(CN, keyPair);
            LOGGER.log(Level.INFO, "Sending Certificate Signing Request for " + CN);
            CSR signedCsr = this.signCSR(csr, endpoint);
            LOGGER.log(Level.INFO, "Gotten signed certificate for " + CN);
            return this.buildStores(CN, userKeyPwd, keyPair.getPrivate(), signedCsr);
        }
        catch (IOException | OperatorCreationException e) {
            throw new HopsSecurityException(RESTCodes.SecurityErrorCode.CERT_CREATION_ERROR, Level.SEVERE, null, null, e);
        }
    }

    private CSR generateCSR(String cn, KeyPair keyPair) throws OperatorCreationException, IOException {
        X500Name subject = new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.CN, cn).build();
        PKCS10CertificationRequest csr = new JcaPKCS10CertificationRequestBuilder(subject, keyPair.getPublic()).build(new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).setProvider(SECURITY_PROVIDER).build(keyPair.getPrivate()));
        PemObject pemObject = new PemObject("CERTIFICATE REQUEST", csr.getEncoded());
        StringWriter csrSTR = new StringWriter();
        JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)csrSTR);
        jcaPEMWriter.writeObject((PemObjectGenerator)pemObject);
        jcaPEMWriter.close();
        csrSTR.close();
        return new CSR(csrSTR.toString());
    }

    private CSR signCSR(CSR csr, Endpoint endpoint) throws HopsSecurityException, GenericException, UnsupportedEncodingException {
        switch (endpoint) {
            case PROJECT: {
                return this.caProxy.signProjectCSR(csr);
            }
        }
        throw new HopsSecurityException(RESTCodes.SecurityErrorCode.CSR_ERROR, Level.FINE, null, "Unknown CSR type " + endpoint.toString());
    }

    private void revokeCertificate(String certificateIdentifier, Endpoint endpoint) throws GenericException, HopsSecurityException {
        switch (endpoint) {
            case PROJECT: {
                this.caProxy.revokeProjectX509(certificateIdentifier);
                break;
            }
            default: {
                throw new HopsSecurityException(RESTCodes.SecurityErrorCode.CERTIFICATE_REVOKATION_ERROR, Level.FINE, null, "Unknown revocation type " + endpoint.toString());
            }
        }
    }

    private Pair<KeyStore, KeyStore> buildStores(String CN, String userKeyPwd, Key privateKey, CSR signedCert) throws HopsSecurityException {
        KeyStore keyStore = null;
        KeyStore trustStore = null;
        try {
            X509Certificate certificate = (X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(signedCert.getSignedCert().getBytes()));
            X509Certificate issuer = (X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(signedCert.getIntermediateCaCert().getBytes()));
            X509Certificate rootCa = (X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(signedCert.getRootCaCert().getBytes()));
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
            Certificate[] chain = new X509Certificate[]{certificate, issuer};
            keyStore.setKeyEntry(CN, privateKey, userKeyPwd.toCharArray(), chain);
            trustStore = KeyStore.getInstance("JKS");
            trustStore.load(null, null);
            trustStore.setCertificateEntry("hops_root_ca", rootCa);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new HopsSecurityException(RESTCodes.SecurityErrorCode.CERT_CREATION_ERROR, Level.SEVERE, null, null, (Throwable)e);
        }
        return new Pair((Object)keyStore, (Object)trustStore);
    }

    public class CertsResult {
        private final String projectName;
        private final String username;

        public CertsResult(String projectName, String username) {
            this.projectName = projectName;
            this.username = username;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getUsername() {
            return this.username;
        }
    }

    private static enum Endpoint {
        PROJECT("project");

        private final String endpointPath;

        private Endpoint(String endpointPath) {
            this.endpointPath = endpointPath;
        }

        public String toString() {
            return this.endpointPath;
        }
    }
}

