/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.hdfs;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.hdfs.HdfsLeDescriptors;
import java.util.List;
import java.util.Random;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;

@Stateless
public class HdfsLeDescriptorsFacade
extends AbstractFacade<HdfsLeDescriptors> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public HdfsLeDescriptorsFacade() {
        super(HdfsLeDescriptors.class);
    }

    public String getRPCEndpoint() {
        try {
            List hdfsLeDescriptorsList = this.em.createNamedQuery("HdfsLeDescriptors.findEndpoint", HdfsLeDescriptors.class).getResultList();
            if (hdfsLeDescriptorsList.isEmpty()) {
                return null;
            }
            int randomNNIndex = new Random().nextInt(hdfsLeDescriptorsList.size());
            HdfsLeDescriptors randomNN = (HdfsLeDescriptors)hdfsLeDescriptorsList.get(randomNNIndex);
            String rpcAddresses = randomNN.getRpcAddresses();
            if ((rpcAddresses = rpcAddresses.trim()).contains(",")) {
                String[] rpcAddressArr = rpcAddresses.split(",");
                return rpcAddressArr[0];
            }
            return rpcAddresses;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public String getLeaderWebEndpoint() {
        try {
            List hdfsLeDescriptorsList = this.em.createNamedQuery("HdfsLeDescriptors.findLeader", HdfsLeDescriptors.class).getResultList();
            if (hdfsLeDescriptorsList.isEmpty()) {
                return null;
            }
            return ((HdfsLeDescriptors)hdfsLeDescriptorsList.get(0)).getHttpAddress();
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

