/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.user.security.audit;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.audit.AccountAudit;
import io.hops.hopsworks.persistence.entity.user.security.audit.RolesAudit;
import io.hops.hopsworks.persistence.entity.user.security.audit.Userlogins;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class AccountAuditFacade
extends AbstractFacade<AccountAudit> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    @EJB
    private Settings settings;
    private Set<String> whitelistUserLogins;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public AccountAuditFacade() {
        super(AccountAudit.class);
    }

    @PostConstruct
    private void init() {
        this.whitelistUserLogins = new HashSet<String>();
        String whitelist = this.settings.getWhitelistUsersLogin();
        String[] whitelistTokens = whitelist.split(",");
        Collections.addAll(this.whitelistUserLogins, whitelistTokens);
    }

    public Userlogins getLastUserLogin(Users user) {
        TypedQuery query = this.em.createNamedQuery("Userlogins.findUserLast", Userlogins.class).setParameter("user", (Object)user).setMaxResults(1);
        List logins = query.getResultList();
        if (!logins.isEmpty()) {
            return (Userlogins)logins.get(0);
        }
        return null;
    }

    public void registerLoginInfo(Users user, String action, String outcome, String remoteHost, String userAgent) {
        if (!this.whitelistUserLogins.contains(user.getEmail())) {
            Userlogins userLogin = new Userlogins(remoteHost, userAgent, user, action, outcome, new Date());
            this.em.persist((Object)userLogin);
        }
    }

    public void registerRoleChange(Users user, String action, String outcome, String message, Users targetUser, String remoteHost, String userAgent) {
        RolesAudit rolesAudit = new RolesAudit(action, new Date(), message, userAgent, remoteHost, outcome, targetUser, user);
        this.em.persist((Object)rolesAudit);
    }

    public void registerAccountChange(Users init, String action, String outcome, String message, Users target, String remoteHost, String userAgent) {
        AccountAudit accountAudit = new AccountAudit(action, new Date(), message, outcome, remoteHost, userAgent, target, init);
        this.em.persist((Object)accountAudit);
    }

    public List<AccountAudit> findByInitiator(Users user) {
        TypedQuery query = this.em.createNamedQuery("AccountAudit.findByInitiator", AccountAudit.class);
        query.setParameter("initiator", (Object)user);
        return query.getResultList();
    }

    public List<AccountAudit> findByInitiatorNotTarget(Users user) {
        TypedQuery query = this.em.createNamedQuery("AccountAudit.findByInitiatorNotTarget", AccountAudit.class);
        query.setParameter("initiator", (Object)user);
        query.setParameter("target", (Object)user);
        return query.getResultList();
    }

    public List<AccountAudit> findByTarget(Users user) {
        TypedQuery query = this.em.createNamedQuery("AccountAudit.findByTarget", AccountAudit.class);
        query.setParameter("target", (Object)user);
        return query.getResultList();
    }

    public AccountAudit findByTargetLatestPwdReset(Users user) {
        TypedQuery query = this.em.createNamedQuery("AccountAudit.findByTargetActionAndMsgLatest", AccountAudit.class);
        query.setParameter("target", (Object)user);
        query.setParameter("outcome", (Object)"SUCCESS");
        query.setParameter("action", (Object)"PASSWORD CHANGE");
        query.setParameter("message", (Object)"Admin reset password");
        query.setMaxResults(1);
        try {
            return (AccountAudit)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

