/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.cached;

import io.hops.hopsworks.common.featurestore.activity.FeaturestoreActivityFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeatureGroupCommitFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.FeatureGroupCommit;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeatureGroupCommitController {
    @EJB
    private FeatureGroupCommitFacade featureGroupCommitFacade;
    @EJB
    private FeaturestoreActivityFacade fsActivityFacade;
    private static final Logger LOGGER = Logger.getLogger(FeatureGroupCommitController.class.getName());

    public FeatureGroupCommit createHudiFeatureGroupCommit(Users user, Featuregroup featuregroup, Long commitTime, Long rowsUpdated, Long rowsInserted, Long rowsDeleted, Integer validationId, Long lastActiveCommitTime) {
        FeatureGroupCommit featureGroupCommit = new FeatureGroupCommit(featuregroup.getId(), commitTime);
        featureGroupCommit.setCommittedOn(new Timestamp(commitTime));
        featureGroupCommit.setNumRowsUpdated(rowsUpdated);
        featureGroupCommit.setNumRowsInserted(rowsInserted);
        featureGroupCommit.setNumRowsDeleted(rowsDeleted);
        featureGroupCommit.setArchived(Boolean.valueOf(false));
        if (validationId == null || validationId > 0) {
            // empty if block
        }
        featureGroupCommit = (FeatureGroupCommit)this.featureGroupCommitFacade.update(featureGroupCommit);
        if (lastActiveCommitTime != null) {
            this.featureGroupCommitFacade.markArchived(featuregroup.getId(), new Timestamp(lastActiveCommitTime));
        }
        this.fsActivityFacade.logCommitActivity(user, featuregroup, featureGroupCommit);
        return featureGroupCommit;
    }

    public Optional<FeatureGroupCommit> findCommitByDate(Featuregroup featuregroup, Long commitTimestamp) {
        if (commitTimestamp != null) {
            return this.featureGroupCommitFacade.findClosestDateCommit(featuregroup.getId(), commitTimestamp);
        }
        return this.featureGroupCommitFacade.findLatestDateCommit(featuregroup.getId());
    }

    public Integer countCommitsInRange(Featuregroup featuregroup, Long startTimestamp, Long endTimestamp) {
        return this.featureGroupCommitFacade.countCommitsInRange(featuregroup.getId(), startTimestamp, endTimestamp);
    }

    public AbstractFacade.CollectionInfo getCommitDetails(Integer featureGroupId, Integer limit, Integer offset, Set<? extends AbstractFacade.SortBy> sort, Set<? extends AbstractFacade.FilterBy> filters) {
        if (filters == null || filters.isEmpty()) {
            return this.featureGroupCommitFacade.getCommitDetails(featureGroupId, limit, offset, sort);
        }
        return this.featureGroupCommitFacade.getCommitDetailsByDate(featureGroupId, limit, offset, sort, filters);
    }

    public void deleteFeatureGroupCommits(Featuregroup featuregroup) {
        List featureGroupCommits;
        while (!(featureGroupCommits = this.featureGroupCommitFacade.getCommitDetails(featuregroup.getId(), AbstractFacade.BATCH_SIZE, 0, null).getItems()).isEmpty()) {
            this.featureGroupCommitFacade.removeBatch(featureGroupCommits);
        }
    }
}

