/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.jdbc;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretPlaintext;
import io.hops.hopsworks.common.featurestore.OptionDTO;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreController;
import io.hops.hopsworks.common.featurestore.storageconnectors.StorageConnectorUtil;
import io.hops.hopsworks.common.featurestore.storageconnectors.jdbc.FeaturestoreJdbcConnectorDTO;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.jdbc.FeaturestoreJdbcConnector;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import io.hops.hopsworks.servicediscovery.HopsworksService;
import io.hops.hopsworks.servicediscovery.tags.HiveTags;
import io.hops.hopsworks.servicediscovery.tags.MysqlTags;
import io.hops.hopsworks.servicediscovery.tags.ServiceTags;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.transaction.Transactional;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturestoreJdbcConnectorController {
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    @EJB
    private SecretsController secretsController;
    @EJB
    private OnlineFeaturestoreController onlineFeaturestoreController;
    @EJB
    private StorageConnectorUtil storageConnectorUtil;
    private static final Logger LOGGER = Logger.getLogger(FeaturestoreJdbcConnectorController.class.getName());

    public FeaturestoreJdbcConnector createFeaturestoreJdbcConnector(FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO) throws FeaturestoreException {
        this.verifyJdbcConnectorConnectionString(featurestoreJdbcConnectorDTO.getConnectionString());
        String argumentsString = this.storageConnectorUtil.fromOptions(featurestoreJdbcConnectorDTO.getArguments());
        this.verifyJdbcConnectorArguments(argumentsString);
        FeaturestoreJdbcConnector featurestoreJdbcConnector = new FeaturestoreJdbcConnector();
        featurestoreJdbcConnector.setArguments(argumentsString);
        featurestoreJdbcConnector.setConnectionString(featurestoreJdbcConnectorDTO.getConnectionString());
        return featurestoreJdbcConnector;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Transactional(rollbackOn={FeaturestoreException.class})
    public FeaturestoreJdbcConnector updateFeaturestoreJdbcConnector(FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO, FeaturestoreJdbcConnector featurestoreJdbcConnector) throws FeaturestoreException {
        String argumentsString;
        if (!Strings.isNullOrEmpty((String)featurestoreJdbcConnectorDTO.getConnectionString())) {
            this.verifyJdbcConnectorConnectionString(featurestoreJdbcConnectorDTO.getConnectionString());
            featurestoreJdbcConnector.setConnectionString(featurestoreJdbcConnectorDTO.getConnectionString());
        }
        if (!Strings.isNullOrEmpty((String)(argumentsString = this.storageConnectorUtil.fromOptions(featurestoreJdbcConnectorDTO.getArguments())))) {
            this.verifyJdbcConnectorArguments(argumentsString);
            featurestoreJdbcConnector.setArguments(argumentsString);
        }
        return featurestoreJdbcConnector;
    }

    private void verifyJdbcConnectorConnectionString(String connectionString) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)connectionString) || connectionString.length() > 5000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_JDBC_CONNECTION_STRING, Level.FINE, ", the JDBC connection string should not be empty and not exceed: 5000 characters");
        }
    }

    private void verifyJdbcConnectorArguments(String arguments) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)arguments) && arguments.length() > 2000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_JDBC_CONNECTION_ARGUMENTS, Level.FINE, "JDBC connection arguments should not exceed: 2000 characters");
        }
    }

    public FeaturestoreJdbcConnectorDTO getJdbcConnectorDTO(Users user, Project project, FeaturestoreConnector featurestoreConnector) throws FeaturestoreException {
        FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO = new FeaturestoreJdbcConnectorDTO(featurestoreConnector);
        featurestoreJdbcConnectorDTO.setArguments(this.storageConnectorUtil.toOptions(featurestoreConnector.getJdbcConnector().getArguments()));
        if (featurestoreJdbcConnectorDTO.getName().equals(this.onlineFeaturestoreController.onlineDbUsername(project, user) + "_onlinefeaturestore")) {
            this.setPasswordPlainTextForOnlineJdbcConnector(user, featurestoreJdbcConnectorDTO, project);
        }
        this.replaceOnlineFsConnectorUrl(featurestoreJdbcConnectorDTO);
        this.replaceOfflineFsConnectorUrl(featurestoreJdbcConnectorDTO);
        return featurestoreJdbcConnectorDTO;
    }

    private String getConnectorPlainPasswordFromSecret(Users user, Project project) {
        String secretName = this.onlineFeaturestoreController.onlineDbUsername(project, user);
        try {
            SecretPlaintext plaintext = this.secretsController.get(user, secretName);
            return plaintext.getPlaintext();
        }
        catch (UserException e) {
            LOGGER.log(Level.SEVERE, "Could not get the online jdbc connector password for project: " + project.getName() + ", user: " + user.getEmail());
            return null;
        }
    }

    private void setPasswordPlainTextForOnlineJdbcConnector(Users user, FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO, Project project) {
        String connectorPassword = this.getConnectorPlainPasswordFromSecret(user, project);
        if (!Strings.isNullOrEmpty((String)this.storageConnectorUtil.fromOptions(featurestoreJdbcConnectorDTO.getArguments())) && !Strings.isNullOrEmpty((String)connectorPassword)) {
            List<OptionDTO> arguments = featurestoreJdbcConnectorDTO.getArguments();
            arguments.forEach(argument -> {
                if (argument.getValue().equals("<SECRETPASSWORD>")) {
                    argument.setValue(connectorPassword);
                }
            });
        }
    }

    private void replaceOnlineFsConnectorUrl(FeaturestoreJdbcConnectorDTO jdbcConnectorDTO) throws FeaturestoreException {
        String connectionString = "";
        try {
            connectionString = jdbcConnectorDTO.getConnectionString().replace(this.serviceDiscoveryController.constructServiceFQDN(HopsworksService.MYSQL.getNameWithTag((ServiceTags)MysqlTags.onlinefs)), this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(HopsworksService.MYSQL.getNameWithTag((ServiceTags)MysqlTags.onlinefs)).getAddress());
        }
        catch (ServiceDiscoveryException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.STORAGE_CONNECTOR_GET_ERROR, Level.SEVERE, "Error resolving MySQL DNS name", e.getMessage(), (Throwable)e);
        }
        jdbcConnectorDTO.setConnectionString(connectionString);
    }

    private void replaceOfflineFsConnectorUrl(FeaturestoreJdbcConnectorDTO jdbcConnectorDTO) throws FeaturestoreException {
        String connectionString = "";
        try {
            connectionString = jdbcConnectorDTO.getConnectionString().replace(this.serviceDiscoveryController.constructServiceFQDN(HopsworksService.HIVE.getNameWithTag((ServiceTags)HiveTags.hiveserver2_tls)), this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(HopsworksService.HIVE.getNameWithTag((ServiceTags)HiveTags.hiveserver2_tls)).getAddress());
        }
        catch (ServiceDiscoveryException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.STORAGE_CONNECTOR_GET_ERROR, Level.SEVERE, "Error resolving Hive DNS name", e.getMessage(), (Throwable)e);
        }
        jdbcConnectorDTO.setConnectionString(connectionString);
    }
}

