/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.command;

import io.hops.hopsworks.persistence.entity.command.SystemCommand;
import io.hops.hopsworks.persistence.entity.host.Hosts;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class SystemCommandFacade {
    private static final Logger LOGGER = Logger.getLogger(SystemCommandFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager entityManager;

    public SystemCommand findById(Integer id) {
        return (SystemCommand)this.entityManager.find(SystemCommand.class, (Object)id);
    }

    public List<SystemCommand> findAll() {
        TypedQuery query = this.entityManager.createNamedQuery("SystemCommand.findAll", SystemCommand.class);
        return query.getResultList();
    }

    public List<SystemCommand> findByHost(Hosts host) {
        TypedQuery query = this.entityManager.createNamedQuery("SystemCommand.findByHost", SystemCommand.class);
        query.setParameter("host", (Object)host);
        return query.getResultList();
    }

    public List<SystemCommand> findUnfinishedByHost(Hosts host) {
        TypedQuery query = this.entityManager.createNamedQuery("SystemCommand.findNotFinishedByHost", SystemCommand.class);
        query.setParameter("host", (Object)host);
        return query.getResultList();
    }

    public void persist(SystemCommand command) {
        this.entityManager.persist((Object)command);
    }

    public void update(SystemCommand command) {
        this.entityManager.merge((Object)command);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void delete(SystemCommand command) {
        SystemCommand deleteCommand = (SystemCommand)this.entityManager.find(SystemCommand.class, (Object)command.getId());
        if (deleteCommand != null) {
            this.entityManager.remove((Object)deleteCommand);
        }
    }
}

